/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.spatial;

import com.mysema.query.spatial.GeometryExpression;
import com.mysema.query.spatial.PointExpression;
import com.mysema.query.spatial.PointOperation;
import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import javax.annotation.Nullable;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;

public abstract class CurveExpression<T extends Geometry>
extends GeometryExpression<T> {
    private static final long serialVersionUID = 6139188586728676033L;
    @Nullable
    private volatile NumberExpression<Double> length;
    @Nullable
    private volatile PointExpression<Point> startPoint;
    @Nullable
    private volatile PointExpression<Point> endPoint;
    @Nullable
    private volatile BooleanExpression closed;
    @Nullable
    private volatile BooleanExpression ring;

    public CurveExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> length() {
        if (this.length == null) {
            this.length = NumberOperation.create(Double.class, SpatialOps.LENGTH, (Expression)this.mixin);
        }
        return this.length;
    }

    public PointExpression<Point> startPoint() {
        if (this.startPoint == null) {
            this.startPoint = PointOperation.create(Point.class, SpatialOps.START_POINT, this.mixin);
        }
        return this.startPoint;
    }

    public PointExpression<Point> endPoint() {
        if (this.endPoint == null) {
            this.endPoint = PointOperation.create(Point.class, SpatialOps.END_POINT, this.mixin);
        }
        return this.endPoint;
    }

    public BooleanExpression isClosed() {
        if (this.closed == null) {
            this.closed = BooleanOperation.create(SpatialOps.IS_CLOSED, (Expression)this.mixin);
        }
        return this.closed;
    }

    public BooleanExpression isRing() {
        if (this.ring == null) {
            this.ring = BooleanOperation.create(SpatialOps.IS_RING, (Expression)this.mixin);
        }
        return this.ring;
    }
}

