/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.spatial;

import com.mysema.query.spatial.PolygonExpression;
import com.mysema.query.spatial.PolygonOperation;
import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.spatial.SurfaceExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import javax.annotation.Nullable;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;

public abstract class PolyhedralSurfaceExpression<T extends PolyHedralSurface>
extends SurfaceExpression<T> {
    private static final long serialVersionUID = -6732418858467327780L;
    @Nullable
    private volatile NumberExpression<Integer> numPatches;
    @Nullable
    private volatile BooleanExpression closed;

    public PolyhedralSurfaceExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Integer> numPatches() {
        if (this.numPatches == null) {
            this.numPatches = NumberOperation.create(Integer.class, SpatialOps.NUM_SURFACES, (Expression)this.mixin);
        }
        return this.numPatches;
    }

    public PolygonExpression<?> patchN(int n) {
        return PolygonOperation.create(Polygon.class, SpatialOps.SURFACE, this.mixin, ConstantImpl.create((int)n));
    }

    public BooleanExpression isClosed() {
        if (this.closed == null) {
            this.closed = BooleanOperation.create(SpatialOps.IS_CLOSED, (Expression)this.mixin);
        }
        return this.closed;
    }
}

