/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.spatial.jts;

import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.spatial.jts.JTSGeometryOperation;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.vividsolutions.jts.geom.Geometry;
import javax.annotation.Nullable;

public abstract class JTSGeometryExpression<T extends Geometry>
extends SimpleExpression<T> {
    private static final long serialVersionUID = -1183228394472681995L;
    @Nullable
    private volatile NumberExpression<Integer> dimension;
    @Nullable
    private volatile NumberExpression<Integer> coordinateDimension;
    @Nullable
    private volatile NumberExpression<Integer> spatialDimension;
    @Nullable
    private volatile NumberExpression<Integer> srid;
    @Nullable
    private volatile StringExpression geometryType;
    @Nullable
    private volatile StringExpression text;
    @Nullable
    private volatile JTSGeometryExpression<Geometry> envelope;
    @Nullable
    private volatile JTSGeometryExpression<Geometry> boundary;
    @Nullable
    private volatile JTSGeometryExpression<Geometry> convexHull;
    @Nullable
    private volatile BooleanExpression empty;
    @Nullable
    private volatile BooleanExpression simple;
    @Nullable
    private volatile BooleanExpression threed;
    @Nullable
    private volatile BooleanExpression measured;
    private volatile SimpleExpression<byte[]> binary;

    public JTSGeometryExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Integer> dimension() {
        if (this.dimension == null) {
            this.dimension = NumberOperation.create(Integer.class, SpatialOps.DIMENSION, (Expression)this.mixin);
        }
        return this.dimension;
    }

    public StringExpression geometryType() {
        if (this.geometryType == null) {
            this.geometryType = StringOperation.create(SpatialOps.GEOMETRY_TYPE, (Expression)this.mixin);
        }
        return this.geometryType;
    }

    public NumberExpression<Integer> srid() {
        if (this.srid == null) {
            this.srid = NumberOperation.create(Integer.class, SpatialOps.SRID, (Expression)this.mixin);
        }
        return this.srid;
    }

    public JTSGeometryExpression<Geometry> envelope() {
        if (this.envelope == null) {
            this.envelope = JTSGeometryOperation.create(Geometry.class, SpatialOps.ENVELOPE, this.mixin);
        }
        return this.envelope;
    }

    public StringExpression asText() {
        if (this.text == null) {
            this.text = StringOperation.create(SpatialOps.AS_TEXT, (Expression)this.mixin);
        }
        return this.text;
    }

    public SimpleExpression<byte[]> asBinary() {
        if (this.binary == null) {
            this.binary = SimpleOperation.create(byte[].class, SpatialOps.AS_BINARY, (Expression)this.mixin);
        }
        return this.binary;
    }

    public BooleanExpression isEmpty() {
        if (this.empty == null) {
            this.empty = BooleanOperation.create(SpatialOps.IS_EMPTY, (Expression)this.mixin);
        }
        return this.empty;
    }

    public BooleanExpression isSimple() {
        if (this.simple == null) {
            this.simple = BooleanOperation.create(SpatialOps.IS_SIMPLE, (Expression)this.mixin);
        }
        return this.simple;
    }

    public JTSGeometryExpression<Geometry> boundary() {
        if (this.boundary == null) {
            this.boundary = JTSGeometryOperation.create(Geometry.class, SpatialOps.BOUNDARY, this.mixin);
        }
        return this.boundary;
    }

    public BooleanExpression eq(Geometry right) {
        return this.eq((Expression<? super T>)ConstantImpl.create((Object)right));
    }

    public BooleanExpression eq(Expression<? super T> right) {
        return BooleanOperation.create(SpatialOps.EQUALS, (Expression)this.mixin, right);
    }

    public BooleanExpression disjoint(Geometry geometry) {
        return this.disjoint((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression disjoint(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.DISJOINT, (Expression)this.mixin, geometry);
    }

    public BooleanExpression intersects(Geometry geometry) {
        return this.intersects((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression intersects(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.INTERSECTS, (Expression)this.mixin, geometry);
    }

    public BooleanExpression touches(Geometry geometry) {
        return this.touches((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression touches(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.TOUCHES, (Expression)this.mixin, geometry);
    }

    public BooleanExpression crosses(Geometry geometry) {
        return this.crosses((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression crosses(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.CROSSES, (Expression)this.mixin, geometry);
    }

    public BooleanExpression within(Geometry geometry) {
        return this.within((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression within(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.WITHIN, (Expression)this.mixin, geometry);
    }

    public BooleanExpression contains(Geometry geometry) {
        return this.contains((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression contains(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.CONTAINS, (Expression)this.mixin, geometry);
    }

    public BooleanExpression overlaps(Geometry geometry) {
        return this.overlaps((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression overlaps(Expression<? extends Geometry> geometry) {
        return BooleanOperation.create(SpatialOps.OVERLAPS, (Expression)this.mixin, geometry);
    }

    public BooleanExpression relate(Geometry geometry, String matrix) {
        return this.relate((Expression<Geometry>)ConstantImpl.create((Object)geometry), matrix);
    }

    public BooleanExpression relate(Expression<? extends Geometry> geometry, String matrix) {
        return BooleanOperation.create(SpatialOps.RELATE, (Expression[])new Expression[]{this.mixin, geometry, ConstantImpl.create((Object)matrix)});
    }

    public NumberExpression<Double> distance(Geometry geometry) {
        return this.distance((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public NumberExpression<Double> distance(Expression<? extends Geometry> geometry) {
        return NumberOperation.create(Double.class, SpatialOps.DISTANCE, (Expression)this.mixin, geometry);
    }

    public NumberExpression<Double> distanceSphere(Expression<? extends Geometry> geometry) {
        return NumberOperation.create(Double.class, SpatialOps.DISTANCE_SPHERE, (Expression)this.mixin, geometry);
    }

    public NumberExpression<Double> distanceSpheroid(Expression<? extends Geometry> geometry) {
        return NumberOperation.create(Double.class, SpatialOps.DISTANCE_SPHEROID, (Expression)this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> buffer(double distance) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.BUFFER, this.mixin, ConstantImpl.create((Object)distance));
    }

    public JTSGeometryExpression<Geometry> convexHull() {
        if (this.convexHull == null) {
            this.convexHull = JTSGeometryOperation.create(Geometry.class, SpatialOps.CONVEXHULL, this.mixin);
        }
        return this.convexHull;
    }

    public JTSGeometryExpression<Geometry> intersection(Geometry geometry) {
        return this.intersection((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> intersection(Expression<? extends Geometry> geometry) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.INTERSECTION, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> union(Geometry geometry) {
        return this.union((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> union(Expression<? extends Geometry> geometry) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.UNION, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> difference(Geometry geometry) {
        return this.difference((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> difference(Expression<? extends Geometry> geometry) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.DIFFERENCE, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> symDifference(Geometry geometry) {
        return this.symDifference((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> symDifference(Expression<? extends Geometry> geometry) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.SYMDIFFERENCE, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> transform(int srid) {
        return JTSGeometryOperation.create(Geometry.class, SpatialOps.TRANSFORM, this.mixin, ConstantImpl.create((int)srid));
    }
}

