/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.types.Null;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class JDBCTypeMapping {
    private static final Map<Integer, Class<?>> defaultTypes = new HashMap();
    private final Map<Integer, Class<?>> types = new HashMap();

    private static void registerDefault(int sqlType, Class<?> javaType) {
        defaultTypes.put(sqlType, javaType);
    }

    public void register(int sqlType, Class<?> javaType) {
        this.types.put(sqlType, javaType);
    }

    @Nullable
    public Class<?> get(int sqlType) {
        if (this.types.containsKey(sqlType)) {
            return this.types.get(sqlType);
        }
        return defaultTypes.get(sqlType);
    }

    static {
        JDBCTypeMapping.registerDefault(-101, Object.class);
        JDBCTypeMapping.registerDefault(-7, Boolean.class);
        JDBCTypeMapping.registerDefault(16, Boolean.class);
        JDBCTypeMapping.registerDefault(-5, Long.class);
        JDBCTypeMapping.registerDefault(3, BigDecimal.class);
        JDBCTypeMapping.registerDefault(8, Double.class);
        JDBCTypeMapping.registerDefault(6, Float.class);
        JDBCTypeMapping.registerDefault(4, Integer.class);
        JDBCTypeMapping.registerDefault(2, BigDecimal.class);
        JDBCTypeMapping.registerDefault(7, Float.class);
        JDBCTypeMapping.registerDefault(5, Short.class);
        JDBCTypeMapping.registerDefault(-6, Byte.class);
        JDBCTypeMapping.registerDefault(91, Date.class);
        JDBCTypeMapping.registerDefault(92, Time.class);
        JDBCTypeMapping.registerDefault(93, Timestamp.class);
        JDBCTypeMapping.registerDefault(1, String.class);
        JDBCTypeMapping.registerDefault(-15, String.class);
        JDBCTypeMapping.registerDefault(2005, String.class);
        JDBCTypeMapping.registerDefault(2011, String.class);
        JDBCTypeMapping.registerDefault(-1, String.class);
        JDBCTypeMapping.registerDefault(-16, String.class);
        JDBCTypeMapping.registerDefault(2009, String.class);
        JDBCTypeMapping.registerDefault(12, String.class);
        JDBCTypeMapping.registerDefault(-9, String.class);
        JDBCTypeMapping.registerDefault(-2, byte[].class);
        JDBCTypeMapping.registerDefault(-4, byte[].class);
        JDBCTypeMapping.registerDefault(-3, byte[].class);
        JDBCTypeMapping.registerDefault(2004, Blob.class);
        JDBCTypeMapping.registerDefault(2003, Object[].class);
        JDBCTypeMapping.registerDefault(2001, Object.class);
        JDBCTypeMapping.registerDefault(70, Object.class);
        JDBCTypeMapping.registerDefault(2000, Object.class);
        JDBCTypeMapping.registerDefault(0, Null.class);
        JDBCTypeMapping.registerDefault(1111, Object.class);
        JDBCTypeMapping.registerDefault(2006, Object.class);
        JDBCTypeMapping.registerDefault(-8, Object.class);
        JDBCTypeMapping.registerDefault(2002, Object.class);
    }
}

