/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.commons.lang.Assert;
import com.mysema.commons.lang.Pair;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.DefaultMapper;
import com.mysema.query.sql.dml.Mapper;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUpdateClause
extends AbstractSQLClause<SQLUpdateClause>
implements UpdateClause<SQLUpdateClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInsertClause.class);
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final List<QueryMetadata> batchMetadata = new ArrayList<QueryMetadata>();
    private final List<List<Pair<Path<?>, Expression<?>>>> batchUpdates = new ArrayList();
    private List<Pair<Path<?>, Expression<?>>> updates = new ArrayList();
    private QueryMetadata metadata = new DefaultQueryMetadata();
    private transient String queryString;

    public SQLUpdateClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLUpdateClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = (Connection)Assert.notNull((Object)connection, (String)"connection");
        this.entity = (RelationalPath)Assert.notNull(entity, (String)"entity");
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLUpdateClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLUpdateClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLUpdateClause addBatch() {
        this.batchUpdates.add(this.updates);
        this.batchMetadata.add(this.metadata);
        this.updates = new ArrayList();
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        return this;
    }

    private PreparedStatement createStatement() throws SQLException {
        PreparedStatement stmt;
        if (this.batchUpdates.isEmpty()) {
            SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
            serializer.serializeForUpdate(this.metadata, this.entity, this.updates);
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
        } else {
            SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
            serializer.serializeForUpdate(this.batchMetadata.get(0), this.entity, this.batchUpdates.get(0));
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
            stmt.addBatch();
            for (int i = 1; i < this.batchUpdates.size(); ++i) {
                serializer = new SQLSerializer(this.configuration.getTemplates(), true, true);
                serializer.serializeForUpdate(this.batchMetadata.get(i), this.entity, this.batchUpdates.get(i));
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    public long execute() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement();
            if (this.batchUpdates.isEmpty()) {
                long l = stmt.executeUpdate();
                return l;
            }
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public <T> SQLUpdateClause set(Path<T> path, T value) {
        if (value instanceof Expression) {
            this.updates.add(Pair.of(path, (Object)((Expression)value)));
        } else if (value != null) {
            this.updates.add(Pair.of(path, (Object)new ConstantImpl(value)));
        } else {
            this.updates.add(Pair.of(path, Null.CONSTANT));
        }
        return this;
    }

    public <T> SQLUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        this.updates.add(Pair.of(path, expression));
        return this;
    }

    public <T> SQLUpdateClause setNull(Path<T> path) {
        this.updates.add(Pair.of(path, Null.CONSTANT));
        return this;
    }

    public SQLUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) instanceof Expression) {
                this.updates.add(Pair.of(paths.get(i), (Object)((Expression)values.get(i))));
                continue;
            }
            if (values.get(i) != null) {
                this.updates.add(Pair.of(paths.get(i), (Object)new ConstantImpl(values.get(i))));
                continue;
            }
            this.updates.add(Pair.of(paths.get(i), Null.CONSTANT));
        }
        return this;
    }

    public SQLUpdateClause where(Predicate ... o) {
        this.metadata.addWhere(o);
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForUpdate(this.metadata, this.entity, this.updates);
        return serializer.toString();
    }

    public SQLUpdateClause populate(Object bean) {
        return this.populate(bean, DefaultMapper.DEFAULT);
    }

    public <T> SQLUpdateClause populate(T obj, Mapper<T> mapper) {
        List primaryKeyColumns = this.entity.getPrimaryKey() != null ? this.entity.getPrimaryKey().getLocalColumns() : Collections.emptyList();
        Map<Path<?>, Object> values = mapper.createMap(this.entity, obj);
        for (Map.Entry<Path<?>, Object> entry : values.entrySet()) {
            if (primaryKeyColumns.contains(entry.getKey())) continue;
            this.set((Path<T>)entry.getKey(), (T)entry.getValue());
        }
        return this;
    }
}

