/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.JDBCTypeMapping;
import com.mysema.query.sql.JavaTypeMapping;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.types.BigDecimalAsDoubleType;
import com.mysema.query.sql.types.Type;
import com.mysema.query.sql.types.UntypedNullType;
import com.mysema.query.types.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class Configuration {
    public static final Configuration DEFAULT = new Configuration(SQLTemplates.DEFAULT);
    private final JDBCTypeMapping jdbcTypeMapping = new JDBCTypeMapping();
    private final JavaTypeMapping javaTypeMapping = new JavaTypeMapping();
    private final SQLTemplates templates;

    public Configuration(SQLTemplates templates) {
        this.templates = templates;
        if (!templates.isParameterMetadataAvailable()) {
            this.javaTypeMapping.register(new UntypedNullType());
        }
        if (!templates.isBigDecimalSupported()) {
            this.javaTypeMapping.register(new BigDecimalAsDoubleType());
        }
    }

    public SQLTemplates getTemplates() {
        return this.templates;
    }

    public Class<?> getJavaType(int sqlType, String tableName, String columnName) {
        Type<?> type = this.javaTypeMapping.getType(tableName, columnName);
        if (type != null) {
            return type.getReturnedClass();
        }
        return this.jdbcTypeMapping.get(sqlType);
    }

    @Nullable
    public <T> T get(ResultSet rs, @Nullable Path<?> path, int i, Class<T> clazz) throws SQLException {
        Type<T> type = this.getType(path, clazz);
        return type.getValue(rs, i);
    }

    public <T> int set(PreparedStatement stmt, Path<?> path, int i, T value) throws SQLException {
        Type<?> type = this.getType(path, value.getClass());
        type.setValue(stmt, i, value);
        return type.getSQLTypes().length;
    }

    private <T> Type<T> getType(@Nullable Path<?> path, Class<T> clazz) {
        String column;
        String table;
        Type<?> type;
        if (path != null && path.getMetadata().getParent() instanceof RelationalPath && (type = this.javaTypeMapping.getType(table = ((RelationalPath)path.getMetadata().getParent()).getTableName(), column = path.getMetadata().getExpression().toString())) != null) {
            return type;
        }
        return this.javaTypeMapping.getType(clazz);
    }

    public void register(Type<?> type) {
        this.jdbcTypeMapping.register(type.getSQLTypes()[0], type.getReturnedClass());
        this.javaTypeMapping.register(type);
    }

    public void register(String table, String column, Type<?> type) {
        this.javaTypeMapping.setType(table, column, type);
    }
}

