/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQueryMixin;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.support.DetachableQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import java.util.List;

public class AbstractSQLSubQuery<Q extends AbstractSQLSubQuery<Q>>
extends DetachableQuery<Q> {
    protected final SQLQueryMixin<Q> queryMixin;

    public AbstractSQLSubQuery() {
        this((QueryMetadata)new DefaultQueryMetadata().noValidate());
    }

    public AbstractSQLSubQuery(QueryMetadata metadata) {
        super(new SQLQueryMixin(metadata));
        this.queryMixin = (SQLQueryMixin)((DetachableQuery)this).queryMixin;
        this.queryMixin.setSelf((Object)this);
    }

    public Q addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        Expression flag = TemplateExpressionImpl.create((Class)expr.getType(), (String)(prefix + "{0}"), (Expression[])new Expression[]{expr});
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public Q addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public Q addJoinFlag(String flag) {
        return this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    public Q addJoinFlag(String flag, JoinFlag.Position position) {
        List joins = this.queryMixin.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(new JoinFlag(flag, position));
        return (Q)((Object)this);
    }

    public Q from(Expression<?> ... args) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.from(args))));
    }

    public Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.from(new Expression[]{ExpressionUtils.as(subQuery, alias)}))));
    }

    public Q fullJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.fullJoin(target))));
    }

    public <E> Q fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <E> Q fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLSubQuery)((Object)this.queryMixin.fullJoin(entity))).on(key.on(entity));
    }

    public Q fullJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public Q innerJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.innerJoin(target))));
    }

    public <E> Q innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <E> Q innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLSubQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public Q innerJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public Q join(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.join(target))));
    }

    public <E> Q join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public <E> Q join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLSubQuery)((Object)this.queryMixin.join(entity))).on(key.on(entity));
    }

    public Q join(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public Q leftJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.leftJoin(target))));
    }

    public <E> Q leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <E> Q leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLSubQuery)((Object)this.queryMixin.leftJoin(entity))).on(key.on(entity));
    }

    public Q leftJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public Q on(Predicate ... conditions) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.on(conditions))));
    }

    public Q rightJoin(RelationalPath<?> target) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.rightJoin(target))));
    }

    public <E> Q rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <E> Q rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLSubQuery)((Object)this.queryMixin.rightJoin(entity))).on(key.on(entity));
    }

    public Q rightJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLSubQuery)((Object)this.queryMixin.rightJoin(target, alias))));
    }

    public String toString() {
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            SQLSerializer serializer = new SQLSerializer(SQLTemplates.DEFAULT);
            serializer.serialize(this.queryMixin.getMetadata(), false);
            return serializer.toString().trim();
        }
        return super.toString();
    }
}

