/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.mssql;

import com.mysema.query.types.Expression;
import com.mysema.query.types.MutableExpressionBase;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.template.NumberTemplate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class RowNumber
extends MutableExpressionBase<Long> {
    private static final long serialVersionUID = 3499501725767772281L;
    private final List<Expression<?>> partitionBy = new ArrayList();
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    @Nullable
    private Expression<Long> target;
    private volatile NumberExpression<Long> value;

    public RowNumber() {
        super(Long.class);
    }

    public NumberExpression<Long> getValue() {
        if (this.value == null) {
            ArrayList args = new ArrayList(this.partitionBy.size() + this.orderBy.size());
            StringBuilder builder = new StringBuilder("row_number() over (");
            if (!this.partitionBy.isEmpty()) {
                builder.append("partition by ");
                this.appendPartition(args, builder);
            }
            if (!this.orderBy.isEmpty()) {
                if (!this.partitionBy.isEmpty()) {
                    builder.append(" ");
                }
                builder.append("order by ");
                this.appendOrder(args, builder);
            }
            builder.append(")");
            if (this.target != null) {
                builder.append(" as {" + args.size() + "}");
                args.add(this.target);
            }
            this.value = NumberTemplate.create(Long.class, (String)builder.toString(), (Expression[])args.toArray(new Expression[args.size()]));
        }
        return this.value;
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)this.getValue().accept(v, context);
    }

    private void appendPartition(List<Expression<?>> args, StringBuilder builder) {
        boolean first = true;
        for (Expression<?> expr : this.partitionBy) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("{" + args.size() + "}");
            args.add(expr);
            first = false;
        }
    }

    private void appendOrder(List<Expression<?>> args, StringBuilder builder) {
        boolean first = true;
        for (OrderSpecifier<?> expr : this.orderBy) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("{" + args.size() + "}");
            if (!expr.isAscending()) {
                builder.append(" desc");
            }
            args.add(expr.getTarget());
            first = false;
        }
    }

    public RowNumber orderBy(OrderSpecifier<?> ... order) {
        this.value = null;
        for (OrderSpecifier<?> o : order) {
            this.orderBy.add(o);
        }
        return this;
    }

    public RowNumber orderBy(ComparableExpression<?> ... order) {
        this.value = null;
        for (ComparableExpression<?> o : order) {
            this.orderBy.add(o.asc());
        }
        return this;
    }

    public RowNumber partitionBy(Expression<?> ... exprs) {
        this.value = null;
        for (Expression<?> expr : exprs) {
            this.partitionBy.add(expr);
        }
        return this;
    }

    public RowNumber as(Expression<Long> target) {
        this.value = null;
        this.target = target;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RowNumber) {
            RowNumber rn = (RowNumber)((Object)o);
            return this.partitionBy.equals(rn.partitionBy) && this.orderBy.equals(rn.orderBy);
        }
        return false;
    }
}

