/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.mssql.RowNumber;
import com.mysema.query.sql.mssql.SQLServerGrammar;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;

public class SQLServerTemplates
extends SQLTemplates {
    private String limitOffsetTemplate = "row_number > {0} and row_number <= {1}";
    private String limitTemplate = "row_number <= {0}";
    private String offsetTemplate = "row_number > {0}";
    private String outerQueryStart = "with inner_query as \n(\n  ";
    private String outerQueryEnd = "\n)\nselect * \nfrom inner_query\nwhere ";

    public SQLServerTemplates() {
        this('\\', false);
    }

    public SQLServerTemplates(boolean quote) {
        this('\\', quote);
    }

    public SQLServerTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.addClass2TypeMappings("decimal", Double.class);
        this.setDummyTable("");
        this.add(Ops.CHAR_AT, "cast(substring({0},{1}+1,1) as char)");
        this.add(Ops.INDEX_OF, "charindex({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "charindex({1},{0},{2})-1");
        this.add(Ops.MATCHES, "{0} like {1}");
        this.add(Ops.STRING_IS_EMPTY, "len({0}) = 0");
        this.add(Ops.STRING_LENGTH, "len({0})");
        this.add(Ops.SUBSTR_1ARG, "substring({0},{1}+1,255)");
        this.add(Ops.SUBSTR_2ARGS, "substring({0},{1}+1,{2})");
        this.add(Ops.TRIM, "ltrim(rtrim({0}))");
        this.add(NEXTVAL, "{0s}.nextval");
        this.add(Ops.DateTimeOps.YEAR, "datepart(year, {0})");
        this.add(Ops.DateTimeOps.MONTH, "datepart(month, {0})");
        this.add(Ops.DateTimeOps.WEEK, "datepart(week, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "datepart(day, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "datepart(weekday, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "datepart(dayofyear, {0})");
        this.add(Ops.DateTimeOps.HOUR, "datepart(hour, {0})");
        this.add(Ops.DateTimeOps.MINUTE, "datepart(minute, {0})");
        this.add(Ops.DateTimeOps.SECOND, "datepart(second, {0})");
        this.add(Ops.DateTimeOps.MILLISECOND, "datepart(millisecond, {0})");
    }

    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            context.append(this.outerQueryStart);
            metadata = metadata.clone();
            RowNumber rn = new RowNumber();
            for (OrderSpecifier os : metadata.getOrderBy()) {
                rn.orderBy(os);
            }
            metadata.addProjection((Expression)rn.as((Expression<Long>)SQLServerGrammar.rowNumber));
            metadata.clearOrderBy();
            context.serializeForQuery(metadata, forCountRow);
            context.append(this.outerQueryEnd);
            QueryModifiers mod = metadata.getModifiers();
            if (mod.getLimit() == null) {
                context.handle(this.offsetTemplate, mod.getOffset());
            } else if (mod.getOffset() == null) {
                context.handle(this.limitTemplate, mod.getLimit());
            } else {
                context.handle(this.limitOffsetTemplate, mod.getOffset(), mod.getLimit() + mod.getOffset());
            }
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
    }
}

