/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;
import java.math.BigDecimal;

public class MySQLTemplates
extends SQLTemplates {
    public MySQLTemplates() {
        this('\\', false);
    }

    public MySQLTemplates(boolean quote) {
        this('\\', quote);
    }

    public MySQLTemplates(char escape, boolean quote) {
        super("`", escape, quote);
        this.setParameterMetadataAvailable(false);
        this.addClass2TypeMappings("bool", Boolean.class);
        this.addClass2TypeMappings("int", Integer.class);
        this.addClass2TypeMappings("decimal", Double.class, Float.class, BigDecimal.class);
        this.addClass2TypeMappings("char", String.class);
        this.add(Ops.CONCAT, "concat({0}, {1})", 0);
        this.add(Ops.DateTimeOps.YEAR_MONTH, "extract(year_month from {0})");
        this.add(Ops.StringOps.LPAD, "lpad({0},{1},' ')");
        this.add(Ops.StringOps.RPAD, "rpad({0},{1},' ')");
        if (escape == '\\') {
            this.add(Ops.LIKE, "{0} like {1}");
            this.add(Ops.ENDS_WITH, "{0} like {%1}");
            this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1}");
            this.add(Ops.STARTS_WITH, "{0} like {1%}");
            this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%}");
            this.add(Ops.STRING_CONTAINS, "{0} like {%1%}");
            this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%}");
        }
        this.add(Ops.MathOps.LOG, "log({1},{0})");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.AggOps.BOOLEAN_ANY, "bit_or({0})", 0);
        this.add(Ops.AggOps.BOOLEAN_ALL, "bit_and({0})", 0);
    }
}

