/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.PrimaryKey;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.RelationalPathUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.path.BeanPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class RelationalPathBase<T>
extends BeanPath<T>
implements RelationalPath<T> {
    private static final long serialVersionUID = -7031357250283629202L;
    @Nullable
    private PrimaryKey<T> primaryKey;
    private final List<Path<?>> columns = new ArrayList();
    private final List<ForeignKey<?>> foreignKeys = new ArrayList();
    private final List<ForeignKey<?>> inverseForeignKeys = new ArrayList();
    private final String schema;
    private final String table;
    private transient FactoryExpression<T> projection;

    public RelationalPathBase(Class<? extends T> type, String variable, String schema, String table) {
        this(type, PathMetadataFactory.forVariable((String)variable), schema, table);
    }

    public RelationalPathBase(Class<? extends T> type, PathMetadata<?> metadata, String schema, String table) {
        super(type, metadata);
        this.schema = schema;
        this.table = table;
    }

    protected PrimaryKey<T> createPrimaryKey(Path<?> ... columns) {
        this.primaryKey = new PrimaryKey(this, columns);
        return this.primaryKey;
    }

    protected <F> ForeignKey<F> createForeignKey(Path<?> local, String foreign) {
        ForeignKey foreignKey = new ForeignKey(this, local, foreign);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createForeignKey(List<? extends Path<?>> local, List<String> foreign) {
        ForeignKey foreignKey = new ForeignKey(this, ImmutableList.copyOf(local), (ImmutableList<String>)ImmutableList.copyOf(foreign));
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createInvForeignKey(Path<?> local, String foreign) {
        ForeignKey foreignKey = new ForeignKey(this, local, foreign);
        this.inverseForeignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createInvForeignKey(List<? extends Path<?>> local, List<String> foreign) {
        ForeignKey foreignKey = new ForeignKey(this, ImmutableList.copyOf(local), (ImmutableList<String>)ImmutableList.copyOf(foreign));
        this.inverseForeignKeys.add(foreignKey);
        return foreignKey;
    }

    public FactoryExpression<T> getProjection() {
        if (this.projection == null) {
            this.projection = RelationalPathUtils.createProjection(this);
        }
        return this.projection;
    }

    public Path<?>[] all() {
        Path[] all = new Path[this.columns.size()];
        this.columns.toArray(all);
        return all;
    }

    protected <P extends Path<?>> P add(P path) {
        this.columns.add(path);
        return path;
    }

    @Override
    public List<Path<?>> getColumns() {
        return this.columns;
    }

    @Override
    public Collection<ForeignKey<?>> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Collection<ForeignKey<?>> getInverseForeignKeys() {
        return this.inverseForeignKeys;
    }

    @Override
    public PrimaryKey<T> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public String getTableName() {
        return this.table;
    }
}

