/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.query.QueryException;
import com.mysema.query.sql.Column;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.dml.Mapper;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.Path;
import com.mysema.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class AnnotationMapper
implements Mapper<Object> {
    public static final AnnotationMapper DEFAULT = new AnnotationMapper(false);
    public static final AnnotationMapper WITH_NULL_BINDINGS = new AnnotationMapper(true);
    private final boolean withNullBindings;

    public AnnotationMapper() {
        this(false);
    }

    public AnnotationMapper(boolean withNullBindings) {
        this.withNullBindings = withNullBindings;
    }

    @Override
    public Map<Path<?>, Object> createMap(RelationalPath<?> path, Object object) {
        try {
            HashMap columnToPath = new HashMap();
            for (Path<?> column : path.getColumns()) {
                columnToPath.put(column.getMetadata().getName(), column);
            }
            HashMap values = new HashMap();
            for (Field field : ReflectionUtils.getFields(object.getClass())) {
                Column ann = field.getAnnotation(Column.class);
                if (ann == null) continue;
                field.setAccessible(true);
                Object propertyValue = field.get(object);
                if (propertyValue != null) {
                    if (!columnToPath.containsKey(ann.value())) continue;
                    values.put((Path<?>)columnToPath.get(ann.value()), propertyValue);
                    continue;
                }
                if (!this.withNullBindings) continue;
                values.put((Path<?>)columnToPath.get(ann.value()), Null.DEFAULT);
            }
            return values;
        }
        catch (IllegalAccessException e) {
            throw new QueryException((Throwable)e);
        }
    }
}

