/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class DerbyTemplates
extends SQLTemplates {
    private String limitOffsetTemplate = "\noffset {1s} rows fetch next {0s} rows only";
    private String limitTemplate = "\nfetch first {0s} rows only";
    private String offsetTemplate = "\noffset {0s} rows";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new DerbyTemplates(escape, quote);
            }
        };
    }

    public DerbyTemplates() {
        this('\\', false);
    }

    public DerbyTemplates(boolean quote) {
        this('\\', quote);
    }

    public DerbyTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setDummyTable("sysibm.sysdummy1");
        this.addClass2TypeMappings("smallint", Byte.class);
        this.setAutoIncrement(" generated always as identity");
        this.setFunctionJoinsWrapped(true);
        this.add(Ops.CONCAT, "varchar({0} || {1})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "day({0})");
        this.add(NEXTVAL, "next value for {0s}");
        this.add(Ops.CASE_EQ, "case {1} end");
        this.add(Ops.CASE_EQ_WHEN, "when {0} = {1} then {2} {3}");
        this.add(Ops.CASE_EQ_ELSE, "else {0}");
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.ROUND, "floor({0})");
        this.add(Ops.MathOps.POWER, "exp({1} * log({0}))");
        this.add(Ops.MathOps.LN, "log({0})");
        this.add(Ops.MathOps.LOG, "(log({0}) / log({1}))");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.DateTimeOps.ADD_YEARS, "{fn timestampadd(SQL_TSI_YEAR, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "{fn timestampadd(SQL_TSI_MONTH, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "{fn timestampadd(SQL_TSI_WEEK, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_DAYS, "{fn timestampadd(SQL_TSI_DAY, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_HOURS, "{fn timestampadd(SQL_TSI_HOUR, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "{fn timestampadd(SQL_TSI_MINUTE, {1}, {0})}");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "{fn timestampadd(SQL_TSI_SECOND, {1}, {0})}");
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.getLimit() == null) {
            context.handle(this.offsetTemplate, mod.getOffset());
        } else if (mod.getOffset() == null) {
            context.handle(this.limitTemplate, mod.getLimit());
        } else {
            context.handle(this.limitOffsetTemplate, mod.getLimit(), mod.getOffset());
        }
    }
}

