/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDeleteClause
extends AbstractSQLClause<SQLDeleteClause>
implements DeleteClause<SQLDeleteClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLDeleteClause.class);
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final List<QueryMetadata> batches = new ArrayList<QueryMetadata>();
    private QueryMetadata metadata = new DefaultQueryMetadata();
    private transient String queryString;

    public SQLDeleteClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLDeleteClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLDeleteClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLDeleteClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLDeleteClause addBatch() {
        this.batches.add(this.metadata);
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        return this;
    }

    private PreparedStatement createStatement() throws SQLException {
        PreparedStatement stmt;
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
            serializer.serializeForDelete(this.metadata, this.entity);
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
        } else {
            SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
            serializer.serializeForDelete(this.batches.get(0), this.entity);
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                serializer = new SQLSerializer(this.configuration.getTemplates(), true);
                serializer.serializeForDelete(this.batches.get(i), this.entity);
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    public long execute() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement();
            if (this.batches.isEmpty()) {
                long l = stmt.executeUpdate();
                return l;
            }
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLDeleteClause where(Predicate p) {
        this.metadata.addWhere(p);
        return this;
    }

    public SQLDeleteClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.metadata.addWhere(p);
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForDelete(this.metadata, this.entity);
        return serializer.toString();
    }
}

