/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLServerTemplates;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.mssql.RowNumber;
import com.mysema.query.sql.mssql.SQLServerGrammar;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;

public class SQLServer2005Templates
extends SQLServerTemplates {
    private String limitOffsetTemplate = "row_number > {0} and row_number <= {1}";
    private String limitTemplate = "row_number <= {0}";
    private String offsetTemplate = "row_number > {0}";
    private String outerQueryStart = "with inner_query as \n(\n  ";
    private String outerQueryEnd = "\n)\nselect * \nfrom inner_query\nwhere ";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new SQLServerTemplates(escape, quote);
            }
        };
    }

    public SQLServer2005Templates() {
        this('\\', false);
    }

    public SQLServer2005Templates(boolean quote) {
        this('\\', quote);
    }

    public SQLServer2005Templates(char escape, boolean quote) {
        super(escape, quote);
    }

    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            QueryModifiers mod = metadata.getModifiers();
            context.append(this.outerQueryStart);
            metadata = metadata.clone();
            RowNumber rn = new RowNumber();
            for (OrderSpecifier os : metadata.getOrderBy()) {
                rn.orderBy(os);
            }
            metadata.addProjection((Expression)rn.as((Expression<Long>)SQLServerGrammar.rowNumber));
            metadata.clearOrderBy();
            context.serializeForQuery(metadata, forCountRow);
            context.append(this.outerQueryEnd);
            if (mod.getLimit() == null) {
                context.handle(this.offsetTemplate, mod.getOffset());
            } else if (mod.getOffset() == null) {
                context.handle(this.limitTemplate, mod.getLimit());
            } else {
                context.handle(this.limitOffsetTemplate, mod.getOffset(), mod.getLimit() + mod.getOffset());
            }
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }
}

