/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLResultIterator;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import com.mysema.util.ResultSetAdapter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLQuery<Q extends AbstractSQLQuery<Q>>
extends ProjectableQuery<Q>
implements SQLCommonQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    @Nullable
    private final Connection conn;
    @Nullable
    private List<Object> constants;
    @Nullable
    private List<Path<?>> constantPaths;
    @Nullable
    protected Expression<?> union;
    private final Configuration configuration;
    protected final QueryMixin<Q> queryMixin;
    protected boolean unionAll;

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata().noValidate());
    }

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(new QueryMixin(metadata, false));
        this.queryMixin = ((ProjectableQuery)this).queryMixin;
        this.queryMixin.setSelf((Object)this);
        this.conn = conn;
        this.configuration = configuration;
    }

    @Override
    public Q addJoinFlag(String flag) {
        return (Q)this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    @Override
    public Q addJoinFlag(String flag, JoinFlag.Position position) {
        this.queryMixin.addJoinFlag(new JoinFlag(flag, position));
        return (Q)this;
    }

    @Override
    public Q addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        SimpleExpression flag = SimpleTemplate.create((Class)expr.getType(), (String)(prefix + "{0}"), expr);
        return (Q)((AbstractSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, (Expression)flag)));
    }

    @Override
    public Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((AbstractSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    @Override
    public Q addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (Q)((AbstractSQLQuery)this.queryMixin.addFlag(new QueryFlag(position, flag)));
    }

    protected String buildQueryString(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstants();
        this.constantPaths = serializer.getConstantPaths();
        return serializer.toString();
    }

    public long count() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists() {
        return ((AbstractSQLQuery)this.limit(1L)).singleResult((Expression)NumberTemplate.ONE) != null;
    }

    public Q forUpdate() {
        return (Q)this.addFlag(QueryFlag.Position.END, this.configuration.getTemplates().getForUpdate());
    }

    protected SQLSerializer createSerializer() {
        return new SQLSerializer(this.configuration.getTemplates());
    }

    public Q from(Expression<?> arg) {
        return (Q)((AbstractSQLQuery)this.queryMixin.from(arg));
    }

    @Override
    public Q from(Expression<?> ... args) {
        return (Q)((AbstractSQLQuery)this.queryMixin.from(args));
    }

    @Override
    public Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.from(ExpressionUtils.as(subQuery, alias)));
    }

    @Override
    public Q fullJoin(RelationalPath<?> target) {
        return (Q)((AbstractSQLQuery)this.queryMixin.fullJoin(target));
    }

    @Override
    public <E> Q fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    public Q fullJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    public <E> Q fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)this.queryMixin.fullJoin(entity)).on(key.on(entity));
    }

    @Override
    public Q innerJoin(RelationalPath<?> target) {
        return (Q)((AbstractSQLQuery)this.queryMixin.innerJoin(target));
    }

    @Override
    public <E> Q innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public Q innerJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public <E> Q innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)this.queryMixin.innerJoin(entity)).on(key.on(entity));
    }

    @Override
    public Q join(RelationalPath<?> target) {
        return (Q)((AbstractSQLQuery)this.queryMixin.join(target));
    }

    @Override
    public <E> Q join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    public Q join(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.join(target, alias));
    }

    @Override
    public <E> Q join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)this.queryMixin.join(entity)).on(key.on(entity));
    }

    @Override
    public Q leftJoin(RelationalPath<?> target) {
        return (Q)((AbstractSQLQuery)this.queryMixin.leftJoin(target));
    }

    @Override
    public <E> Q leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public Q leftJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public <E> Q leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)this.queryMixin.leftJoin(entity)).on(key.on(entity));
    }

    @Override
    public Q rightJoin(RelationalPath<?> target) {
        return (Q)((AbstractSQLQuery)this.queryMixin.rightJoin(target));
    }

    @Override
    public <E> Q rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    public Q rightJoin(SubQueryExpression<?> target, Path<?> alias) {
        return (Q)((AbstractSQLQuery)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    public <E> Q rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)this.queryMixin.rightJoin(entity)).on(key.on(entity));
    }

    @Nullable
    private <T> T get(ResultSet rs, Expression<?> expr, int i, Class<T> type) throws SQLException {
        return this.configuration.get(rs, expr instanceof Path ? (Path)expr : null, i, type);
    }

    private void set(PreparedStatement stmt, Path<?> path, int i, Object value) throws SQLException {
        this.configuration.set(stmt, path, i, value);
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public ResultSet getResults(Expression<?> ... exprs) {
        this.queryMixin.addProjection(exprs);
        String queryString = this.buildQueryString(false);
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        try {
            final PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, this.getMetadata().getParams());
            ResultSet rs = stmt.executeQuery();
            ResultSetAdapter resultSetAdapter = new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
            return resultSetAdapter;
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = UnionUtils.union(sq, this.unionAll);
        return new UnionImpl(this, sq[0].getMetadata().getProjection());
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> expr) {
        expr = this.queryMixin.addProjection(expr);
        return this.iterateSingle(this.queryMixin.getMetadata(), expr);
    }

    private <RT> CloseableIterator<RT> iterateSingle(QueryMetadata metadata, final @Nullable Expression<RT> expr) {
        String queryString = this.buildQueryString(false);
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        try {
            PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, metadata.getParams());
            ResultSet rs = stmt.executeQuery();
            if (expr == null) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        return rs.getObject(1);
                    }
                };
                return sQLResultIterator;
            }
            if (expr instanceof FactoryExpression) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        return AbstractSQLQuery.this.newInstance((FactoryExpression)expr, rs, 0);
                    }
                };
                return sQLResultIterator;
            }
            if (expr.getType().isArray()) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        Object[] rv = new Object[rs.getMetaData().getColumnCount()];
                        for (int i = 0; i < rv.length; ++i) {
                            rv[i] = rs.getObject(i + 1);
                        }
                        return rv;
                    }
                };
                return sQLResultIterator;
            }
            SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                @Override
                public RT produceNext(ResultSet rs) throws Exception {
                    return AbstractSQLQuery.this.get(rs, expr, 1, expr.getType());
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public List<Tuple> list(Expression<?> ... args) {
        return this.list((Expression<RT>)((Expression)new QTuple(args)));
    }

    /*
     * Exception decompiling
     */
    public <RT> List<RT> list(Expression<RT> expr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)((Expression)new QTuple(args)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        this.queryMixin.addProjection(expr);
        long total = this.count();
        try {
            if (total > 0L) {
                this.queryMixin.getMetadata().clearProjection();
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                SearchResults searchResults = new SearchResults(this.list(expr), modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    private <RT> RT newInstance(FactoryExpression<RT> c, ResultSet rs, int offset) throws InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Object[] args = new Object[c.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.get(rs, (Expression)c.getArgs().get(i), offset + i + 1, ((Expression)c.getArgs().get(i)).getType());
        }
        return (RT)c.newInstance(args);
    }

    public Q on(Predicate condition) {
        return (Q)((AbstractSQLQuery)this.queryMixin.on(condition));
    }

    @Override
    public Q on(Predicate ... conditions) {
        return (Q)((AbstractSQLQuery)this.queryMixin.on(conditions));
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected void setParameters(PreparedStatement stmt, List<?> objects, List<Path<?>> constantPaths, Map<ParamExpression<?>, ?> params) {
        if (objects.size() != constantPaths.size()) {
            throw new IllegalArgumentException("Expected " + objects.size() + " paths, but got " + constantPaths.size());
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            try {
                if (o instanceof ParamExpression) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((ParamExpression)o);
                    }
                    o = params.get(o);
                }
                this.set(stmt, constantPaths.get(i), i + 1, o);
                continue;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public String toString() {
        return this.buildQueryString(false).trim();
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, false));
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, false));
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, true));
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from(UnionUtils.union(sq, alias, true));
    }

    public Tuple uniqueResult(Expression<?> ... expr) {
        return (Tuple)this.uniqueResult((Expression<RT>)((Expression)new QTuple(expr)));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        if (this.getMetadata().getModifiers().getLimit() == null && !expr.toString().contains("count(")) {
            this.limit(2L);
        }
        CloseableIterator<RT> iterator = this.iterate(expr);
        return (RT)this.uniqueResult(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        String queryString = this.buildQueryString(true);
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.constantPaths, this.getMetadata().getParams());
            rs = stmt.executeQuery();
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

