/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class PostgresTemplates
extends SQLTemplates {
    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new PostgresTemplates(escape, quote);
            }
        };
    }

    public PostgresTemplates() {
        this('\\', false);
    }

    public PostgresTemplates(boolean quote) {
        this('\\', quote);
    }

    public PostgresTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setDummyTable(null);
        this.addClass2TypeMappings("numeric(3,0)", Byte.class);
        this.addClass2TypeMappings("double precision", Double.class);
        this.add(Ops.MATCHES, "{0} ~ {1}");
        this.add(Ops.INDEX_OF, "strpos({0},{1})-1");
        this.add(Ops.INDEX_OF_2ARGS, "strpos({0},{1})-1");
        this.add(Ops.StringOps.LOCATE, "strpos({1},{0})");
        this.add(Ops.StringOps.LOCATE2, "strpos(repeat('^',{2s}-1) || substr({1},{2s}),{0})");
        if (escape == '\\') {
            this.add(Ops.LIKE, "{0} like {1}");
            this.add(Ops.ENDS_WITH, "{0} like {%1}");
            this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1}");
            this.add(Ops.STARTS_WITH, "{0} like {1%}");
            this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%}");
            this.add(Ops.STRING_CONTAINS, "{0} like {%1%}");
            this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%}");
        }
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.LOG, "log({1},{0})");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.YEAR, "extract(year from {0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "extract(year from {0}) * 100 + extract(month from {0})");
        this.add(Ops.DateTimeOps.MONTH, "extract(month from {0})");
        this.add(Ops.DateTimeOps.WEEK, "extract(week from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "extract(day from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "extract(dow from {0}) + 1");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "extract(doy from {0})");
        this.add(Ops.DateTimeOps.HOUR, "extract(hour from {0})");
        this.add(Ops.DateTimeOps.MINUTE, "extract(minute from {0})");
        this.add(Ops.DateTimeOps.SECOND, "extract(second from {0})");
        this.add(Ops.AggOps.BOOLEAN_ANY, "bool_or({0})", 0);
        this.add(Ops.AggOps.BOOLEAN_ALL, "bool_and({0})", 0);
        this.add(Ops.DateTimeOps.ADD_YEARS, "{0} + interval '{1s} years'");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "{0} + interval '{1s} months'");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "{0} + interval '{1s} weeks'");
        this.add(Ops.DateTimeOps.ADD_DAYS, "{0} + interval '{1s} days'");
        this.add(Ops.DateTimeOps.ADD_HOURS, "{0} + interval '{1s} hours'");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "{0} + interval '{1s} minutes'");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "{0} + interval '{1s} seconds'");
        String yearsDiff = "date_part('year', age({1}, {0}))";
        String monthsDiff = "(" + yearsDiff + " * 12 + date_part('month', age({1}, {0})))";
        String weeksDiff = "trunc(({1}::date - {0}::date)/7)";
        String daysDiff = "({1}::date - {0}::date)";
        String hoursDiff = "(" + daysDiff + " * 24 + date_part('hour', age({1}, {0})))";
        String minutesDiff = "(" + hoursDiff + " * 60 + date_part('minute', age({1}, {0})))";
        String secondsDiff = "(" + minutesDiff + " * 60 + date_part('minute', age({1}, {0})))";
        this.add(Ops.DateTimeOps.DIFF_YEARS, yearsDiff);
        this.add(Ops.DateTimeOps.DIFF_MONTHS, monthsDiff);
        this.add(Ops.DateTimeOps.DIFF_WEEKS, weeksDiff);
        this.add(Ops.DateTimeOps.DIFF_DAYS, daysDiff);
        this.add(Ops.DateTimeOps.DIFF_HOURS, hoursDiff);
        this.add(Ops.DateTimeOps.DIFF_MINUTES, minutesDiff);
        this.add(Ops.DateTimeOps.DIFF_SECONDS, secondsDiff);
    }
}

