/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.DatePart;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.WindowOver;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.Wildcard;
import java.util.HashMap;
import java.util.Map;

public final class SQLExpressions {
    private static final Map<DatePart, Operator> DATE_ADD_OPS = new HashMap<DatePart, Operator>();
    private static final Map<DatePart, Operator> DATE_DIFF_OPS = new HashMap<DatePart, Operator>();
    private static final Map<DatePart, Operator> DATE_TRUNC_OPS = new HashMap<DatePart, Operator>();
    private static final WindowOver<Long> rank;
    private static final WindowOver<Long> denseRank;
    private static final WindowOver<Long> rowNumber;
    public static final Expression<Object[]> all;
    public static final Expression<Long> countAll;

    public static BooleanExpression any(BooleanExpression expr) {
        return BooleanOperation.create((Operator)Ops.AggOps.BOOLEAN_ANY, (Expression)expr);
    }

    public static BooleanExpression all(BooleanExpression expr) {
        return BooleanOperation.create((Operator)Ops.AggOps.BOOLEAN_ALL, (Expression)expr);
    }

    public static final SimpleExpression<Long> nextval(String sequence) {
        return SQLExpressions.nextval(Long.class, sequence);
    }

    public static final <T extends Number> SimpleExpression<T> nextval(Class<T> type, String sequence) {
        return SimpleOperation.create(type, SQLTemplates.NEXTVAL, (Expression)ConstantImpl.create((String)sequence));
    }

    public static <D extends Comparable> DateExpression<D> date(DateTimeExpression<D> dateTime) {
        return DateOperation.create((Class)dateTime.getType(), (Operator)Ops.DateTimeOps.DATE, dateTime);
    }

    public static <D extends Comparable> DateExpression<D> date(Class<D> type, DateTimeExpression<?> dateTime) {
        return DateOperation.create(type, (Operator)Ops.DateTimeOps.DATE, dateTime);
    }

    public static <D extends Comparable> DateTimeExpression<D> dateadd(DatePart unit, DateTimeExpression<D> date, int amount) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)DATE_ADD_OPS.get((Object)unit), date, (Expression)ConstantImpl.create((int)amount));
    }

    public static <D extends Comparable> DateExpression<D> dateadd(DatePart unit, DateExpression<D> date, int amount) {
        return DateOperation.create((Class)date.getType(), (Operator)DATE_ADD_OPS.get((Object)unit), date, (Expression)ConstantImpl.create((int)amount));
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateExpression<D> start, DateExpression<D> end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), start, end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, D start, DateExpression<D> end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), (Expression)new ConstantImpl(start), end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateExpression<D> start, D end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), start, (Expression)new ConstantImpl(end));
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateTimeExpression<D> start, DateTimeExpression<D> end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), start, end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, D start, DateTimeExpression<D> end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), (Expression)new ConstantImpl(start), end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateTimeExpression<D> start, D end) {
        return NumberOperation.create(Integer.class, (Operator)DATE_DIFF_OPS.get((Object)unit), start, (Expression)new ConstantImpl(end));
    }

    public static <D extends Comparable> DateExpression<D> datetrunc(DatePart unit, DateExpression<D> expr) {
        return DateOperation.create((Class)expr.getType(), (Operator)DATE_TRUNC_OPS.get((Object)unit), expr);
    }

    public static <D extends Comparable> DateTimeExpression<D> datetrunc(DatePart unit, DateTimeExpression<D> expr) {
        return DateTimeOperation.create((Class)expr.getType(), (Operator)DATE_TRUNC_OPS.get((Object)unit), expr);
    }

    public static <D extends Comparable> DateTimeExpression<D> addYears(DateTimeExpression<D> date, int years) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_YEARS, date, (Expression)ConstantImpl.create((int)years));
    }

    public static <D extends Comparable> DateTimeExpression<D> addMonths(DateTimeExpression<D> date, int months) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_MONTHS, date, (Expression)ConstantImpl.create((int)months));
    }

    public static <D extends Comparable> DateTimeExpression<D> addWeeks(DateTimeExpression<D> date, int weeks) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_WEEKS, date, (Expression)ConstantImpl.create((int)weeks));
    }

    public static <D extends Comparable> DateTimeExpression<D> addDays(DateTimeExpression<D> date, int days) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_DAYS, date, (Expression)ConstantImpl.create((int)days));
    }

    public static <D extends Comparable> DateTimeExpression<D> addHours(DateTimeExpression<D> date, int hours) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_HOURS, date, (Expression)ConstantImpl.create((int)hours));
    }

    public static <D extends Comparable> DateTimeExpression<D> addMinutes(DateTimeExpression<D> date, int minutes) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_MINUTES, date, (Expression)ConstantImpl.create((int)minutes));
    }

    public static <D extends Comparable> DateTimeExpression<D> addSeconds(DateTimeExpression<D> date, int seconds) {
        return DateTimeOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_SECONDS, date, (Expression)ConstantImpl.create((int)seconds));
    }

    public static <D extends Comparable> DateExpression<D> addYears(DateExpression<D> date, int years) {
        return DateOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_YEARS, date, (Expression)ConstantImpl.create((int)years));
    }

    public static <D extends Comparable> DateExpression<D> addMonths(DateExpression<D> date, int months) {
        return DateOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_MONTHS, date, (Expression)ConstantImpl.create((int)months));
    }

    public static <D extends Comparable> DateExpression<D> addWeeks(DateExpression<D> date, int weeks) {
        return DateOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_WEEKS, date, (Expression)ConstantImpl.create((int)weeks));
    }

    public static <D extends Comparable> DateExpression<D> addDays(DateExpression<D> date, int days) {
        return DateOperation.create((Class)date.getType(), (Operator)Ops.DateTimeOps.ADD_DAYS, date, (Expression)ConstantImpl.create((int)days));
    }

    public static <T extends Number> WindowOver<T> sum(Expression<T> expr) {
        return new WindowOver(expr.getType(), Ops.AggOps.SUM_AGG, expr);
    }

    public static WindowOver<Long> count(Expression<?> expr) {
        return new WindowOver<Long>(Long.class, Ops.AggOps.COUNT_AGG, expr);
    }

    public static <T extends Number> WindowOver<T> avg(Expression<T> expr) {
        return new WindowOver(expr.getType(), Ops.AggOps.AVG_AGG, expr);
    }

    public static <T extends Comparable> WindowOver<T> min(Expression<T> expr) {
        return new WindowOver(expr.getType(), Ops.AggOps.MIN_AGG, expr);
    }

    public static <T extends Comparable> WindowOver<T> max(Expression<T> expr) {
        return new WindowOver(expr.getType(), Ops.AggOps.MAX_AGG, expr);
    }

    public static <T> WindowOver<T> lead(Expression<T> expr) {
        return new WindowOver<Object>(expr.getType(), SQLTemplates.LEAD, expr);
    }

    public static <T> WindowOver<T> lag(Expression<T> expr) {
        return new WindowOver<Object>(expr.getType(), SQLTemplates.LAG, expr);
    }

    public static WindowOver<Long> rank() {
        return rank;
    }

    public static WindowOver<Long> denseRank() {
        return denseRank;
    }

    public static WindowOver<Long> rowNumber() {
        return rowNumber;
    }

    public static <T> WindowOver<T> firstValue(Expression<T> expr) {
        return new WindowOver<Object>(expr.getType(), SQLTemplates.FIRSTVALUE, expr);
    }

    public static <T> WindowOver<T> lastValue(Expression<T> expr) {
        return new WindowOver<Object>(expr.getType(), SQLTemplates.LASTVALUE, expr);
    }

    private SQLExpressions() {
    }

    static {
        DATE_ADD_OPS.put(DatePart.year, Ops.DateTimeOps.ADD_YEARS);
        DATE_ADD_OPS.put(DatePart.month, Ops.DateTimeOps.ADD_MONTHS);
        DATE_ADD_OPS.put(DatePart.week, Ops.DateTimeOps.ADD_WEEKS);
        DATE_ADD_OPS.put(DatePart.day, Ops.DateTimeOps.ADD_DAYS);
        DATE_ADD_OPS.put(DatePart.hour, Ops.DateTimeOps.ADD_HOURS);
        DATE_ADD_OPS.put(DatePart.minute, Ops.DateTimeOps.ADD_MINUTES);
        DATE_ADD_OPS.put(DatePart.second, Ops.DateTimeOps.ADD_SECONDS);
        DATE_ADD_OPS.put(DatePart.millisecond, null);
        DATE_DIFF_OPS.put(DatePart.year, Ops.DateTimeOps.DIFF_YEARS);
        DATE_DIFF_OPS.put(DatePart.month, Ops.DateTimeOps.DIFF_MONTHS);
        DATE_DIFF_OPS.put(DatePart.week, Ops.DateTimeOps.DIFF_WEEKS);
        DATE_DIFF_OPS.put(DatePart.day, Ops.DateTimeOps.DIFF_DAYS);
        DATE_DIFF_OPS.put(DatePart.hour, Ops.DateTimeOps.DIFF_HOURS);
        DATE_DIFF_OPS.put(DatePart.minute, Ops.DateTimeOps.DIFF_MINUTES);
        DATE_DIFF_OPS.put(DatePart.second, Ops.DateTimeOps.DIFF_SECONDS);
        DATE_DIFF_OPS.put(DatePart.millisecond, null);
        DATE_TRUNC_OPS.put(DatePart.year, Ops.DateTimeOps.TRUNC_YEAR);
        DATE_TRUNC_OPS.put(DatePart.month, Ops.DateTimeOps.TRUNC_MONTH);
        DATE_TRUNC_OPS.put(DatePart.week, Ops.DateTimeOps.TRUNC_WEEK);
        DATE_TRUNC_OPS.put(DatePart.day, Ops.DateTimeOps.TRUNC_DAY);
        DATE_TRUNC_OPS.put(DatePart.hour, Ops.DateTimeOps.TRUNC_HOUR);
        DATE_TRUNC_OPS.put(DatePart.minute, Ops.DateTimeOps.TRUNC_MINUTE);
        DATE_TRUNC_OPS.put(DatePart.second, Ops.DateTimeOps.TRUNC_SECOND);
        rank = new WindowOver<Long>(Long.class, SQLTemplates.RANK);
        denseRank = new WindowOver<Long>(Long.class, SQLTemplates.DENSERANK);
        rowNumber = new WindowOver<Long>(Long.class, SQLTemplates.ROWNUMBER);
        all = Wildcard.all;
        countAll = Wildcard.count;
    }
}

