/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MutableExpressionBase;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.template.SimpleTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WindowFunction<A>
extends MutableExpressionBase<A> {
    private static final long serialVersionUID = -4130672293308756779L;
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    private final List<Expression<?>> partitionBy = new ArrayList();
    private final Expression<A> target;
    private volatile SimpleExpression<A> value;

    public WindowFunction(Expression<A> expr) {
        super(expr.getType());
        this.target = expr;
    }

    public SimpleExpression<A> getValue() {
        if (this.value == null) {
            boolean first;
            int size = 0;
            ImmutableList.Builder args = ImmutableList.builder();
            StringBuilder builder = new StringBuilder();
            builder.append("{0} over (");
            args.add(this.target);
            ++size;
            if (!this.partitionBy.isEmpty()) {
                builder.append("partition by ");
                first = true;
                for (Expression<?> expression : this.partitionBy) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append("{" + size + "}");
                    args.add(expression);
                    ++size;
                    first = false;
                }
            }
            if (!this.orderBy.isEmpty()) {
                if (!this.partitionBy.isEmpty()) {
                    builder.append(" ");
                }
                builder.append("order by ");
                first = true;
                for (OrderSpecifier orderSpecifier : this.orderBy) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append("{" + size + "}");
                    if (!orderSpecifier.isAscending()) {
                        builder.append(" desc");
                    }
                    args.add((Object)orderSpecifier.getTarget());
                    ++size;
                    first = false;
                }
            }
            builder.append(")");
            this.value = new SimpleTemplate(this.target.getType(), TemplateFactory.DEFAULT.create(builder.toString()), args.build());
        }
        return this.value;
    }

    public SimpleExpression<A> as(Expression<A> alias) {
        return SimpleOperation.create((Class)this.getType(), (Operator)Ops.ALIAS, (Expression)this, alias);
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)this.getValue().accept(v, context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WindowFunction) {
            WindowFunction so = (WindowFunction)((Object)o);
            return so.target.equals(this.target) && so.partitionBy.equals(this.partitionBy) && so.orderBy.equals(this.orderBy);
        }
        return false;
    }

    public WindowFunction<A> orderBy(ComparableExpressionBase<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy.asc());
        return this;
    }

    public WindowFunction<A> orderBy(ComparableExpressionBase<?> ... orderBy) {
        this.value = null;
        for (ComparableExpressionBase<?> e : orderBy) {
            this.orderBy.add(e.asc());
        }
        return this;
    }

    public WindowFunction<A> orderBy(OrderSpecifier<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy);
        return this;
    }

    public WindowFunction<A> orderBy(OrderSpecifier<?> ... orderBy) {
        this.value = null;
        this.orderBy.addAll(Arrays.asList(orderBy));
        return this;
    }

    public WindowFunction<A> partitionBy(Expression<?> partitionBy) {
        this.value = null;
        this.partitionBy.add(partitionBy);
        return this;
    }

    public WindowFunction<A> partitionBy(Expression<?> ... partitionBy) {
        this.value = null;
        this.partitionBy.addAll(Arrays.asList(partitionBy));
        return this;
    }
}

