/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLQueryFactory;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.sql.dml.SQLDeleteClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLMergeClause;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.types.Expression;
import java.sql.Connection;
import javax.inject.Provider;

public abstract class AbstractSQLQueryFactory<Q extends SQLCommonQuery<?>>
implements SQLQueryFactory<Q, SQLSubQuery, SQLDeleteClause, SQLUpdateClause, SQLInsertClause, SQLMergeClause> {
    protected final Configuration configuration;
    protected final Provider<Connection> connection;

    public AbstractSQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        this.configuration = configuration;
        this.connection = connection;
    }

    @Override
    public final SQLDeleteClause delete(RelationalPath<?> path) {
        return new SQLDeleteClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final Q from(Expression<?> from) {
        return this.query().from(from);
    }

    @Override
    public final SQLInsertClause insert(RelationalPath<?> path) {
        return new SQLInsertClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLMergeClause merge(RelationalPath<?> path) {
        return new SQLMergeClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLUpdateClause update(RelationalPath<?> path) {
        return new SQLUpdateClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLSubQuery subQuery() {
        return new SQLSubQuery();
    }

    @Override
    public final SQLSubQuery subQuery(Expression<?> from) {
        return (SQLSubQuery)this.subQuery().from(from);
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final Connection getConnection() {
        return (Connection)this.connection.get();
    }
}

