/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class HSQLDBTemplates
extends SQLTemplates {
    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new HSQLDBTemplates(escape, quote);
            }
        };
    }

    public HSQLDBTemplates() {
        this('\\', false);
    }

    public HSQLDBTemplates(boolean quote) {
        this('\\', quote);
    }

    public HSQLDBTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setAutoIncrement(" identity");
        this.add(Ops.TRIM, "trim(both from {0})");
        this.add(Ops.NEGATE, "{0} * -1", 7);
        this.add(NEXTVAL, "next value for {0s}");
        this.add(Ops.MathOps.ROUND, "round({0},0)");
        this.add(Ops.MathOps.LN, "log({0})");
        this.add(Ops.MathOps.LOG, "(log({0}) / log({1}))");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.ADD_YEARS, "dateadd('yy', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "dateadd('mm', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "dateadd('week', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_DAYS, "dateadd('dd', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_HOURS, "dateadd('hh', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "dateadd('mi', {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "dateadd('ss', {1s}, {0})");
        this.add(Ops.DateTimeOps.DIFF_YEARS, "datediff('yy', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_MONTHS, "datediff('mm', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_WEEKS, "datediff('week', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_DAYS, "datediff('dd', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_HOURS, "datediff('hh', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_MINUTES, "datediff('mi', {0}, {1})");
        this.add(Ops.DateTimeOps.DIFF_SECONDS, "datediff('ss', {0}, {1})");
        this.add(Ops.DateTimeOps.DATE, "convert({0}, date)");
    }

    @Override
    public String getTypeForCast(Class<?> cl) {
        return cl.equals(String.class) ? "varchar(10)" : this.getTypeForClass(cl);
    }
}

