/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;
import java.math.BigInteger;

public class OracleTemplates
extends SQLTemplates {
    private String outerQueryStart = "select * from (\n select a.*, rownum rn from (\n  ";
    private String outerQueryEnd = "\n ) a) where ";
    private String limitQueryStart = "select * from (\n  ";
    private String limitQueryEnd = "\n) where rownum <= {0}";
    private String limitOffsetTemplate = "rn > {0s} and rn <= {1s}";
    private String offsetTemplate = "rn > {0}";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new OracleTemplates(escape, quote);
            }
        };
    }

    public OracleTemplates() {
        this('\\', false);
    }

    public OracleTemplates(boolean quote) {
        this('\\', quote);
    }

    public OracleTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setParameterMetadataAvailable(false);
        this.setBatchCountViaGetUpdateCount(true);
        this.addClass2TypeMappings("number(3,0)", Byte.class);
        this.addClass2TypeMappings("number(1,0)", Boolean.class);
        this.addClass2TypeMappings("number(19,0)", BigInteger.class, Long.class);
        this.addClass2TypeMappings("number(5,0)", Short.class);
        this.addClass2TypeMappings("number(10,0)", Integer.class);
        this.addClass2TypeMappings("double precision", Double.class);
        this.addClass2TypeMappings("varchar(4000 char)", String.class);
        this.add(Ops.ALIAS, "{0} {1}");
        this.add(NEXTVAL, "{0s}.nextval");
        this.add(Ops.INDEX_OF, "instrb({0},{1})-1");
        this.add(Ops.INDEX_OF_2ARGS, "instrb({0},{1},{2}+1)-1");
        this.add(Ops.MATCHES, "regexp_like({0},{1})");
        this.add(Ops.StringOps.LOCATE, "instr({1},{0})");
        this.add(Ops.StringOps.LOCATE2, "instr({1},{0},{2s})");
        this.add(Ops.MathOps.CEIL, "ceil({0})");
        this.add(Ops.MathOps.RANDOM, "dbms_random.value");
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.LOG, "log({1},{0})");
        this.add(Ops.MathOps.COT, "(cos({0}) / sin({0}))");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.DEG, "({0} * 180 / 3.141592653589793)");
        this.add(Ops.MathOps.RAD, "({0} * 3.141592653589793 / 180)");
        this.add(Ops.DateTimeOps.DATE, "trunc({0})");
        this.add(Ops.DateTimeOps.YEAR, "extract(year from {0})");
        this.add(Ops.DateTimeOps.MONTH, "extract(month from {0})");
        this.add(Ops.DateTimeOps.WEEK, "to_number(to_char({0},'WW'))");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "to_number(to_char({0},'DD'))");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "to_number(to_char({0},'D')) + 1");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "to_number(to_char({0},'DDD'))");
        this.add(Ops.DateTimeOps.HOUR, "to_number(to_char({0},'HH24'))");
        this.add(Ops.DateTimeOps.MINUTE, "to_number(to_char({0},'MI'))");
        this.add(Ops.DateTimeOps.SECOND, "to_number(to_char({0},'SS'))");
        this.add(Ops.DateTimeOps.YEAR_WEEK, "to_number(to_char({0},'IYYY') || to_char({0},'IW'))");
        this.add(Ops.DateTimeOps.ADD_YEARS, "{0} + interval '{1s}' year");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "{0} + interval '{1s}' month");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "{0} + interval '{1s}' week");
        this.add(Ops.DateTimeOps.ADD_DAYS, "{0} + interval '{1s}' day");
        this.add(Ops.DateTimeOps.ADD_HOURS, "{0} + interval '{1s}' hour");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "{0} + interval '{1s}' minute");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "{0} + interval '{1s}' second");
        this.add(Ops.DateTimeOps.DIFF_YEARS, "round(({1} - {0}) / 365)");
        this.add(Ops.DateTimeOps.DIFF_MONTHS, "round(({1} - {0}) / 30)");
        this.add(Ops.DateTimeOps.DIFF_WEEKS, "round(({1} - {0}) / 7)");
        this.add(Ops.DateTimeOps.DIFF_DAYS, "round({1} - {0})");
        this.add(Ops.DateTimeOps.DIFF_HOURS, "round(({1} - {0}) * 24)");
        this.add(Ops.DateTimeOps.DIFF_MINUTES, "round(({1} - {0}) * 1440)");
        this.add(Ops.DateTimeOps.DIFF_SECONDS, "round(({1} - {0}) * 86400)");
        this.add(Ops.DateTimeOps.TRUNC_YEAR, "trunc({0}, 'year')");
        this.add(Ops.DateTimeOps.TRUNC_MONTH, "trunc({0}, 'month')");
        this.add(Ops.DateTimeOps.TRUNC_WEEK, "trunc({0}, 'w')");
        this.add(Ops.DateTimeOps.TRUNC_DAY, "trunc({0}, 'day')");
        this.add(Ops.DateTimeOps.TRUNC_HOUR, "trunc({0}, 'hh')");
        this.add(Ops.DateTimeOps.TRUNC_MINUTE, "trunc({0}, 'mi')");
        this.add(Ops.DateTimeOps.TRUNC_SECOND, "{0}");
    }

    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            QueryModifiers mod = metadata.getModifiers();
            if (mod.getOffset() == null) {
                context.append(this.limitQueryStart);
                context.serializeForQuery(metadata, forCountRow);
                context.handle(this.limitQueryEnd, mod.getLimit());
            } else {
                context.append(this.outerQueryStart);
                context.serializeForQuery(metadata, forCountRow);
                context.append(this.outerQueryEnd);
                if (mod.getLimit() == null) {
                    context.handle(this.offsetTemplate, mod.getOffset());
                } else {
                    context.handle(this.limitOffsetTemplate, mod.getOffset(), mod.getLimit() + mod.getOffset());
                }
            }
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
    }
}

