/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.primitives.Primitives;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.types.Operator;
import com.mysema.query.types.OperatorImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Templates;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SQLTemplates
extends Templates {
    public static final Operator<Object> CAST = new OperatorImpl("SQL_CAST");
    public static final Operator<Object> UNION = new OperatorImpl("SQL_UNION");
    public static final Operator<Object> UNION_ALL = new OperatorImpl("SQL_UNION_ALL");
    public static final Operator<Object> NEXTVAL = new OperatorImpl("SQL_NEXTVAL");
    public static final Operator<Long> ROWNUMBER = new OperatorImpl("ROWNUMBER");
    public static final Operator<Long> RANK = new OperatorImpl("RANK");
    public static final Operator<Long> DENSERANK = new OperatorImpl("DENSERANK");
    public static final Operator<Object> FIRSTVALUE = new OperatorImpl("FIRSTVALUE");
    public static final Operator<Object> LASTVALUE = new OperatorImpl("LASTVALUE");
    public static final Operator<Object> LEAD = new OperatorImpl("LEAD");
    public static final Operator<Object> LAG = new OperatorImpl("LAG");
    public static final SQLTemplates DEFAULT = new SQLTemplates("\"", '\\', false);
    private final Map<Class<?>, String> class2type = new HashMap();
    private final String quoteStr;
    private final boolean useQuotes;
    private boolean printSchema;
    private String createTable = "create table ";
    private String asc = " asc";
    private String autoIncrement = " auto_increment";
    private String columnAlias = " ";
    private String count = "count ";
    private String countStar = "count(*)";
    private String deleteFrom = "delete from ";
    private String desc = " desc";
    private String distinctCountEnd = ")";
    private String distinctCountStart = "count(distinct ";
    private String dummyTable = "dual";
    private String forUpdate = "\nfor update";
    private String forShare = "\nfor share";
    private String from = "\nfrom ";
    private String fullJoin = "\nfull join ";
    private String groupBy = "\ngroup by ";
    private String having = "\nhaving ";
    private String innerJoin = "\ninner join ";
    private String insertInto = "insert into ";
    private String join = "\njoin ";
    private String key = "key";
    private String leftJoin = "\nleft join ";
    private String rightJoin = "\nright join ";
    private String limitTemplate = "\nlimit {0}";
    private String mergeInto = "merge into ";
    private boolean nativeMerge;
    private String notNull = " not null";
    private String noWait = " nowait";
    private String offsetTemplate = "\noffset {0}";
    private String on = "\non ";
    private String orderBy = "\norder by ";
    private String select = "select ";
    private String selectDistinct = "select distinct ";
    private String set = "set ";
    private String tableAlias = " ";
    private String update = "update ";
    private String values = "\nvalues ";
    private String where = "\nwhere ";
    private String with = "with ";
    private String createIndex = "create index ";
    private String createUniqueIndex = "create unique index ";
    private String nullsFirst = " nulls first";
    private String nullsLast = " nulls last";
    private boolean parameterMetadataAvailable = true;
    private boolean batchCountViaGetUpdateCount = false;
    private boolean bigDecimalSupported = true;
    private boolean unionsWrapped = true;
    private boolean functionJoinsWrapped = false;

    protected SQLTemplates(String quoteStr, char escape, boolean useQuotes) {
        super(escape);
        this.quoteStr = quoteStr;
        this.useQuotes = useQuotes;
        this.add(Ops.AND, "{0} and {1}", 36);
        this.add(Ops.NOT, "not {0}", 35);
        this.add(Ops.OR, "{0} or {1}", 38);
        this.add(Ops.XNOR, "{0} xnor {1}", 39);
        this.add(Ops.XOR, "{0} xor {1}", 39);
        this.add(Ops.MathOps.RANDOM, "rand()");
        this.add(Ops.MathOps.RANDOM2, "rand({0})");
        this.add(Ops.MathOps.CEIL, "ceiling({0})");
        this.add(Ops.MathOps.POWER, "power({0},{1})");
        this.add(Ops.MOD, "mod({0},{1})", -1);
        this.add(Ops.DateTimeOps.CURRENT_DATE, "current_date");
        this.add(Ops.DateTimeOps.CURRENT_TIME, "current_time");
        this.add(Ops.DateTimeOps.CURRENT_TIMESTAMP, "current_timestamp");
        this.add(Ops.DateTimeOps.MILLISECOND, "0");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "(year({0}) * 100 + month({0}))");
        this.add(Ops.DateTimeOps.YEAR_WEEK, "(year({0}) * 100 + week({0}))");
        this.add(Ops.DateTimeOps.ADD_YEARS, "dateadd('year',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "dateadd('month',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "dateadd('week',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_DAYS, "dateadd('day',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_HOURS, "dateadd('hour',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "dateadd('minute',{1},{0})");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "dateadd('second',{1},{0})");
        this.add(Ops.DateTimeOps.DIFF_YEARS, "datediff('year',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MONTHS, "datediff('month',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_WEEKS, "datediff('week',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_DAYS, "datediff('day',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_HOURS, "datediff('hour',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MINUTES, "datediff('minute',{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_SECONDS, "datediff('second',{0},{1})");
        this.add(Ops.DateTimeOps.TRUNC_YEAR, "date_trunc('year',{0})");
        this.add(Ops.DateTimeOps.TRUNC_MONTH, "date_trunc('month',{0})");
        this.add(Ops.DateTimeOps.TRUNC_WEEK, "date_trunc('week',{0})");
        this.add(Ops.DateTimeOps.TRUNC_DAY, "date_trunc('day',{0})");
        this.add(Ops.DateTimeOps.TRUNC_HOUR, "date_trunc('hour',{0})");
        this.add(Ops.DateTimeOps.TRUNC_MINUTE, "date_trunc('minute',{0})");
        this.add(Ops.DateTimeOps.TRUNC_SECOND, "date_trunc('second',{0})");
        this.add(Ops.CONCAT, "{0} || {1}", 38);
        this.add(Ops.MATCHES, "{0} regexp {1}", 25);
        this.add(Ops.CHAR_AT, "cast(substr({0},{1s}+1,1) as char)");
        this.add(Ops.EQ_IGNORE_CASE, "{0l} = {1l}");
        this.add(Ops.INDEX_OF, "locate({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "locate({1},{0},{2s}+1)-1");
        this.add(Ops.STRING_IS_EMPTY, "length({0}) = 0");
        this.add(Ops.SUBSTR_1ARG, "substr({0},{1s}+1)", 1);
        this.add(Ops.SUBSTR_2ARGS, "substr({0},{1s}+1,{2s}-{1s})", 1);
        this.add(Ops.StringOps.LOCATE, "locate({0},{1})");
        this.add(Ops.StringOps.LOCATE2, "locate({0},{1},{2})");
        this.add(Ops.LIKE, "{0} like {1} escape '" + escape + "'");
        this.add(Ops.ENDS_WITH, "{0} like {%1} escape '" + escape + "'");
        this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1} escape '" + escape + "'");
        this.add(Ops.STARTS_WITH, "{0} like {1%} escape '" + escape + "'");
        this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%} escape '" + escape + "'");
        this.add(Ops.STRING_CONTAINS, "{0} like {%1%} escape '" + escape + "'");
        this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%} escape '" + escape + "'");
        this.add(CAST, "cast({0} as {1s})");
        this.add(UNION, "{0}\nunion\n{1}", 1);
        this.add(UNION_ALL, "{0}\nunion all\n{1}", 1);
        this.add(NEXTVAL, "nextval('{0s}')");
        this.add(ROWNUMBER, "row_number()");
        this.add(RANK, "rank()");
        this.add(DENSERANK, "dense_rank()");
        this.add(FIRSTVALUE, "first_value({0})");
        this.add(LASTVALUE, "last_value({0})");
        this.add(LEAD, "lead({0})");
        this.add(LAG, "lag({0})");
        this.add(Ops.AggOps.BOOLEAN_ANY, "some({0})");
        this.add(Ops.AggOps.BOOLEAN_ALL, "every({0})");
        for (Class cl : new Class[]{Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class}) {
            this.class2type.put(cl, cl.getSimpleName().toLowerCase(Locale.ENGLISH));
        }
        this.class2type.put(Boolean.class, "bit");
        this.class2type.put(Byte.class, "tinyint");
        this.class2type.put(Long.class, "bigint");
        this.class2type.put(Short.class, "smallint");
        this.class2type.put(String.class, "varchar");
        this.class2type.put(Date.class, "date");
        this.class2type.put(Time.class, "time");
        this.class2type.put(Timestamp.class, "timestamp");
    }

    protected void addClass2TypeMappings(String type, Class<?> ... classes) {
        for (Class<?> cl : classes) {
            this.class2type.put(cl, type);
        }
    }

    public final String getAsc() {
        return this.asc;
    }

    public final String getAutoIncrement() {
        return this.autoIncrement;
    }

    public final String getColumnAlias() {
        return this.columnAlias;
    }

    public final String getCount() {
        return this.count;
    }

    public final String getCountStar() {
        return this.countStar;
    }

    public final String getDeleteFrom() {
        return this.deleteFrom;
    }

    public final String getDesc() {
        return this.desc;
    }

    public final String getDistinctCountEnd() {
        return this.distinctCountEnd;
    }

    public final String getDistinctCountStart() {
        return this.distinctCountStart;
    }

    public final String getDummyTable() {
        return this.dummyTable;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getFullJoin() {
        return this.fullJoin;
    }

    public final String getGroupBy() {
        return this.groupBy;
    }

    public final String getHaving() {
        return this.having;
    }

    public final String getInnerJoin() {
        return this.innerJoin;
    }

    public final String getInsertInto() {
        return this.insertInto;
    }

    public final String getJoin() {
        return this.join;
    }

    public final String getJoinSymbol(JoinType joinType) {
        switch (joinType) {
            case JOIN: {
                return this.join;
            }
            case INNERJOIN: {
                return this.innerJoin;
            }
            case FULLJOIN: {
                return this.fullJoin;
            }
            case LEFTJOIN: {
                return this.leftJoin;
            }
            case RIGHTJOIN: {
                return this.rightJoin;
            }
        }
        return ", ";
    }

    public final String getKey() {
        return this.key;
    }

    public final String getLeftJoin() {
        return this.leftJoin;
    }

    public final String getRightJoin() {
        return this.rightJoin;
    }

    public final String getLimitTemplate() {
        return this.limitTemplate;
    }

    public final String getMergeInto() {
        return this.mergeInto;
    }

    public final String getNotNull() {
        return this.notNull;
    }

    public final String getOffsetTemplate() {
        return this.offsetTemplate;
    }

    public final String getOn() {
        return this.on;
    }

    public final String getOrderBy() {
        return this.orderBy;
    }

    public final String getSelect() {
        return this.select;
    }

    public final String getSelectDistinct() {
        return this.selectDistinct;
    }

    public final String getSet() {
        return this.set;
    }

    public final String getTableAlias() {
        return this.tableAlias;
    }

    public String getTypeForCast(Class<?> cl) {
        return this.getTypeForClass(cl);
    }

    public String getTypeForClass(Class<?> cl) {
        Class clazz = Primitives.wrap(cl);
        if (this.class2type.containsKey(clazz)) {
            return this.class2type.get(clazz);
        }
        throw new IllegalArgumentException("Got not type for " + clazz.getName());
    }

    public final String getUpdate() {
        return this.update;
    }

    public final String getValues() {
        return this.values;
    }

    public final String getWhere() {
        return this.where;
    }

    public final boolean isNativeMerge() {
        return this.nativeMerge;
    }

    public final boolean isSupportsAlias() {
        return true;
    }

    public final String getCreateIndex() {
        return this.createIndex;
    }

    public final String getCreateUniqueIndex() {
        return this.createUniqueIndex;
    }

    public final String getCreateTable() {
        return this.createTable;
    }

    public final boolean isPrintSchema() {
        return this.printSchema;
    }

    public final String getWith() {
        return this.with;
    }

    public final boolean isParameterMetadataAvailable() {
        return this.parameterMetadataAvailable;
    }

    public final boolean isBatchCountViaGetUpdateCount() {
        return this.batchCountViaGetUpdateCount;
    }

    public final boolean isBigDecimalSupported() {
        return this.bigDecimalSupported;
    }

    public final String getForUpdate() {
        return this.forUpdate;
    }

    public final String getForShare() {
        return this.forShare;
    }

    public final boolean isUseQuotes() {
        return this.useQuotes;
    }

    public final String getNoWait() {
        return this.noWait;
    }

    public final boolean isUnionsWrapped() {
        return this.unionsWrapped;
    }

    public final boolean isFunctionJoinsWrapped() {
        return this.functionJoinsWrapped;
    }

    public final String getNullsFirst() {
        return this.nullsFirst;
    }

    public final String getNullsLast() {
        return this.nullsLast;
    }

    protected void newLineToSingleSpace() {
        for (Class cl : Arrays.asList(((Object)((Object)this)).getClass(), SQLTemplates.class)) {
            for (Field field : cl.getDeclaredFields()) {
                try {
                    if (!field.getType().equals(String.class)) continue;
                    field.setAccessible(true);
                    Object val = field.get((Object)this);
                    if (val == null) continue;
                    field.set((Object)this, val.toString().replace('\n', ' '));
                }
                catch (IllegalAccessException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public final String quoteIdentifier(String identifier) {
        if (this.useQuotes || this.requiresQuotes(identifier)) {
            return this.quoteStr + identifier + this.quoteStr;
        }
        return identifier;
    }

    protected boolean requiresQuotes(String identifier) {
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (!(ch < '0' || ch > '9' && ch < 'A' || ch > 'Z' && ch < '_') && ch <= 'z') continue;
            return true;
        }
        return false;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        context.serializeForQuery(metadata, forCountRow);
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }

    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.getLimit() != null) {
            context.handle(this.limitTemplate, mod.getLimit());
        }
        if (mod.getOffset() != null) {
            context.handle(this.offsetTemplate, mod.getOffset());
        }
    }

    protected void setAsc(String asc) {
        this.asc = asc;
    }

    protected void setAutoIncrement(String autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    protected void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    protected void setCount(String count) {
        this.count = count;
    }

    protected void setCountStar(String countStar) {
        this.countStar = countStar;
    }

    protected void setDeleteFrom(String deleteFrom) {
        this.deleteFrom = deleteFrom;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
    }

    protected void setDistinctCountEnd(String distinctCountEnd) {
        this.distinctCountEnd = distinctCountEnd;
    }

    protected void setDistinctCountStart(String distinctCountStart) {
        this.distinctCountStart = distinctCountStart;
    }

    protected void setDummyTable(String dummyTable) {
        this.dummyTable = dummyTable;
    }

    protected void setFrom(String from) {
        this.from = from;
    }

    protected void setFullJoin(String fullJoin) {
        this.fullJoin = fullJoin;
    }

    protected void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    protected void setHaving(String having) {
        this.having = having;
    }

    protected void setInnerJoin(String innerJoin) {
        this.innerJoin = innerJoin;
    }

    protected void setInsertInto(String insertInto) {
        this.insertInto = insertInto;
    }

    protected void setJoin(String join) {
        this.join = join;
    }

    protected void setKey(String key) {
        this.key = key;
    }

    protected void setLeftJoin(String leftJoin) {
        this.leftJoin = leftJoin;
    }

    protected void setRightJoin(String rightJoin) {
        this.rightJoin = rightJoin;
    }

    protected void setMergeInto(String mergeInto) {
        this.mergeInto = mergeInto;
    }

    protected void setNativeMerge(boolean nativeMerge) {
        this.nativeMerge = nativeMerge;
    }

    protected void setNotNull(String notNull) {
        this.notNull = notNull;
    }

    protected void setOffsetTemplate(String offsetTemplate) {
        this.offsetTemplate = offsetTemplate;
    }

    protected void setOn(String on) {
        this.on = on;
    }

    protected void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    protected void setSelect(String select) {
        this.select = select;
    }

    protected void setSelectDistinct(String selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    protected void setSet(String set) {
        this.set = set;
    }

    protected void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    protected void setUpdate(String update) {
        this.update = update;
    }

    protected void setValues(String values) {
        this.values = values;
    }

    protected void setWhere(String where) {
        this.where = where;
    }

    protected void setWith(String with) {
        this.with = with;
    }

    protected void setCreateIndex(String createIndex) {
        this.createIndex = createIndex;
    }

    protected void setCreateUniqueIndex(String createUniqueIndex) {
        this.createUniqueIndex = createUniqueIndex;
    }

    protected void setCreateTable(String createTable) {
        this.createTable = createTable;
    }

    protected void setPrintSchema(boolean printSchema) {
        this.printSchema = printSchema;
    }

    protected void setParameterMetadataAvailable(boolean parameterMetadataAvailable) {
        this.parameterMetadataAvailable = parameterMetadataAvailable;
    }

    protected void setBatchCountViaGetUpdateCount(boolean batchCountViaGetUpdateCount) {
        this.batchCountViaGetUpdateCount = batchCountViaGetUpdateCount;
    }

    protected void setBigDecimalSupported(boolean bigDecimalSupported) {
        this.bigDecimalSupported = bigDecimalSupported;
    }

    protected void setForUpdate(String forUpdate) {
        this.forUpdate = forUpdate;
    }

    protected void setForShare(String forShare) {
        this.forShare = forShare;
    }

    protected void setNoWait(String noWait) {
        this.noWait = noWait;
    }

    protected void setUnionsWrapped(boolean unionsWrapped) {
        this.unionsWrapped = unionsWrapped;
    }

    protected void setFunctionJoinsWrapped(boolean functionJoinsWrapped) {
        this.functionJoinsWrapped = functionJoinsWrapped;
    }

    protected void setNullsFirst(String nullsFirst) {
        this.nullsFirst = nullsFirst;
    }

    protected void setNullsLast(String nullsLast) {
        this.nullsLast = nullsLast;
    }

    public static abstract class Builder {
        protected boolean printSchema;
        protected boolean quote;
        protected boolean newLineToSingleSpace;
        protected char escape = (char)92;

        public Builder printSchema() {
            this.printSchema = true;
            return this;
        }

        public Builder quote() {
            this.quote = true;
            return this;
        }

        public Builder newLineToSingleSpace() {
            this.newLineToSingleSpace = true;
            return this;
        }

        public Builder escape(char ch) {
            this.escape = ch;
            return this;
        }

        protected abstract SQLTemplates build(char var1, boolean var2);

        public SQLTemplates build() {
            SQLTemplates templates = this.build(this.escape, this.quote);
            if (this.newLineToSingleSpace) {
                templates.newLineToSingleSpace();
            }
            templates.setPrintSchema(this.printSchema);
            return templates;
        }
    }
}

