/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.Maps;
import com.mysema.commons.lang.Pair;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.JDBCTypeMapping;
import com.mysema.query.sql.JavaTypeMapping;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLListeners;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.types.BigDecimalAsDoubleType;
import com.mysema.query.sql.types.Null;
import com.mysema.query.sql.types.Type;
import com.mysema.query.types.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nullable;

public final class Configuration {
    public static final Configuration DEFAULT = new Configuration(SQLTemplates.DEFAULT);
    private final JDBCTypeMapping jdbcTypeMapping = new JDBCTypeMapping();
    private final JavaTypeMapping javaTypeMapping = new JavaTypeMapping();
    private final Map<String, String> schemas = Maps.newHashMap();
    private final Map<Pair<String, String>, String> schemaTables = Maps.newHashMap();
    private final Map<String, String> tables = Maps.newHashMap();
    private final SQLTemplates templates;
    private final SQLListeners listeners = new SQLListeners();
    private boolean hasTableColumnTypes = false;

    public Configuration(SQLTemplates templates) {
        this.templates = templates;
        if (!templates.isBigDecimalSupported()) {
            this.javaTypeMapping.register(new BigDecimalAsDoubleType());
        }
    }

    public SQLTemplates getTemplates() {
        return this.templates;
    }

    public Class<?> getJavaType(int sqlType, int size, int digits, String tableName, String columnName) {
        Type<?> type = this.javaTypeMapping.getType(tableName, columnName);
        if (type != null) {
            return type.getReturnedClass();
        }
        return this.jdbcTypeMapping.get(sqlType, size, digits);
    }

    @Nullable
    public <T> T get(ResultSet rs, @Nullable Path<?> path, int i, Class<T> clazz) throws SQLException {
        return this.getType(path, clazz).getValue(rs, i);
    }

    public String getSchema(String schema) {
        if (this.schemas.containsKey(schema)) {
            return this.schemas.get(schema);
        }
        return schema;
    }

    public String getTable(String schema, String table) {
        Pair key;
        if (!this.schemaTables.isEmpty() && schema != null && this.schemaTables.containsKey(key = Pair.of((Object)schema, (Object)table))) {
            return this.schemaTables.get(key);
        }
        if (this.tables.containsKey(table)) {
            return this.tables.get(table);
        }
        return table;
    }

    public <T> void set(PreparedStatement stmt, Path<?> path, int i, T value) throws SQLException {
        if (Null.class.isInstance(value)) {
            Integer sqlType;
            Integer n = sqlType = path != null ? this.jdbcTypeMapping.get(path.getType()) : null;
            if (sqlType != null) {
                stmt.setNull(i, sqlType);
            } else {
                stmt.setNull(i, 0);
            }
        } else {
            this.getType(path, value.getClass()).setValue(stmt, i, value);
        }
    }

    private <T> Type<T> getType(@Nullable Path<?> path, Class<T> clazz) {
        String column;
        String table;
        Type<?> type;
        if (this.hasTableColumnTypes && path != null && !clazz.equals(Null.class) && path.getMetadata().getParent() instanceof RelationalPath && (type = this.javaTypeMapping.getType(table = ((RelationalPath)path.getMetadata().getParent()).getTableName(), column = ColumnMetadata.getName(path))) != null) {
            return type;
        }
        return this.javaTypeMapping.getType(clazz);
    }

    public String registerSchemaOverride(String oldSchema, String newSchema) {
        return this.schemas.put(oldSchema, newSchema);
    }

    public String registerTableOverride(String oldTable, String newTable) {
        return this.tables.put(oldTable, newTable);
    }

    public String registerTableOverride(String schema, String oldTable, String newTable) {
        return this.schemaTables.put((Pair<String, String>)Pair.of((Object)schema, (Object)oldTable), newTable);
    }

    public void register(Type<?> type) {
        this.jdbcTypeMapping.register(type.getSQLTypes()[0], type.getReturnedClass());
        this.javaTypeMapping.register(type);
    }

    public void registerNumeric(int size, int digits, Class<?> javaType) {
        this.jdbcTypeMapping.registerNumeric(size, digits, javaType);
    }

    public void register(String table, String column, Type<?> type) {
        this.javaTypeMapping.setType(table, column, type);
        this.hasTableColumnTypes = true;
    }

    public void addListener(SQLListener listener) {
        this.listeners.add(listener);
    }

    public SQLListeners getListeners() {
        return this.listeners;
    }
}

