/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableSet;
import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;
import com.mysema.query.util.CollectionUtils;
import java.util.Set;

public class RelationalPathExtractor
implements Visitor<Set<RelationalPath<?>>, Set<RelationalPath<?>>> {
    public static final RelationalPathExtractor DEFAULT = new RelationalPathExtractor();

    public static Set<RelationalPath<?>> extract(QueryMetadata md) {
        Object known = ImmutableSet.of();
        known = DEFAULT.visitJoins(md.getJoins(), (Set<RelationalPath<?>>)known);
        for (Expression p : md.getProjection()) {
            known = (Set)p.accept((Visitor)DEFAULT, known);
        }
        for (OrderSpecifier o : md.getOrderBy()) {
            known = (Set)o.getTarget().accept((Visitor)DEFAULT, known);
        }
        for (Expression g : md.getGroupBy()) {
            known = (Set)g.accept((Visitor)DEFAULT, known);
        }
        if (md.getHaving() != null) {
            known = (Set)md.getHaving().accept((Visitor)DEFAULT, known);
        }
        if (md.getWhere() != null) {
            known = (Set)md.getWhere().accept((Visitor)DEFAULT, known);
        }
        return known;
    }

    public static Set<RelationalPath<?>> extract(Expression<?> expr) {
        return (Set)expr.accept((Visitor)DEFAULT, (Object)ImmutableSet.of());
    }

    public Set<RelationalPath<?>> visit(Constant<?> expr, Set<RelationalPath<?>> known) {
        return known;
    }

    public Set<RelationalPath<?>> visit(FactoryExpression<?> expr, Set<RelationalPath<?>> known) {
        for (Expression arg : expr.getArgs()) {
            known = (Set)arg.accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(Operation<?> expr, Set<RelationalPath<?>> known) {
        for (Expression arg : expr.getArgs()) {
            known = (Set)arg.accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(ParamExpression<?> expr, Set<RelationalPath<?>> known) {
        return known;
    }

    public Set<RelationalPath<?>> visit(Path<?> expr, Set<RelationalPath<?>> known) {
        if (expr.getMetadata().isRoot()) {
            if (expr instanceof RelationalPath) {
                known = CollectionUtils.add(known, (Object)((RelationalPath)expr));
            }
        } else {
            known = (Set)expr.getMetadata().getParent().accept((Visitor)this, known);
        }
        return known;
    }

    public Set<RelationalPath<?>> visit(SubQueryExpression<?> expr, Set<RelationalPath<?>> known) {
        Set old = known;
        QueryMetadata md = expr.getMetadata();
        known = this.visitJoins(md.getJoins(), known);
        for (Expression p : md.getProjection()) {
            known = (Set)p.accept((Visitor)this, known);
        }
        for (OrderSpecifier o : md.getOrderBy()) {
            known = (Set)o.getTarget().accept((Visitor)this, (Object)known);
        }
        for (Expression g : md.getGroupBy()) {
            known = (Set)g.accept((Visitor)this, (Object)known);
        }
        if (md.getHaving() != null) {
            known = (Set)md.getHaving().accept((Visitor)this, (Object)known);
        }
        if (md.getWhere() != null) {
            known = (Set)md.getWhere().accept((Visitor)this, (Object)known);
        }
        return old;
    }

    public Set<RelationalPath<?>> visit(TemplateExpression<?> expr, Set<RelationalPath<?>> known) {
        for (Object arg : expr.getArgs()) {
            if (!(arg instanceof Expression)) continue;
            known = (Set)((Expression)arg).accept((Visitor)this, known);
        }
        return known;
    }

    private Set<RelationalPath<?>> visitJoins(Iterable<JoinExpression> joins, Set<RelationalPath<?>> known) {
        for (JoinExpression j : joins) {
            known = (Set)j.getTarget().accept((Visitor)this, known);
            if (j.getCondition() == null) continue;
            known = (Set)j.getCondition().accept((Visitor)this, (Object)known);
        }
        return known;
    }

    private RelationalPathExtractor() {
    }
}

