/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.google.common.collect.ImmutableList;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.DMLClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLListeners;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class AbstractSQLClause<C extends AbstractSQLClause<C>>
implements DMLClause<C> {
    protected final Configuration configuration;
    protected final SQLListeners listeners;

    public AbstractSQLClause(Configuration configuration) {
        this.configuration = configuration;
        this.listeners = new SQLListeners(configuration.getListeners());
    }

    public void addListener(SQLListener listener) {
        this.listeners.add(listener);
    }

    protected SQLBindings createBindings(QueryMetadata metadata, SQLSerializer serializer) {
        String queryString = serializer.toString();
        ImmutableList.Builder args = ImmutableList.builder();
        Map params = metadata.getParams();
        for (Object o : serializer.getConstants()) {
            if (o instanceof ParamExpression) {
                if (!params.containsKey(o)) {
                    throw new ParamNotSetException((ParamExpression)o);
                }
                o = metadata.getParams().get(o);
            }
            args.add(o);
        }
        return new SQLBindings(queryString, (ImmutableList<Object>)args.build());
    }

    public abstract List<SQLBindings> getSQL();

    protected void setParameters(PreparedStatement stmt, List<?> objects, List<Path<?>> constantPaths, Map<ParamExpression<?>, ?> params) {
        if (objects.size() != constantPaths.size()) {
            throw new IllegalArgumentException("Expected " + objects.size() + " paths, " + "but got " + constantPaths.size());
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            try {
                if (o instanceof ParamExpression) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((ParamExpression)o);
                    }
                    o = params.get(o);
                }
                this.configuration.set(stmt, constantPaths.get(i), i + 1, o);
                continue;
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected long executeBatch(PreparedStatement stmt) throws SQLException {
        if (this.configuration.getTemplates().isBatchCountViaGetUpdateCount()) {
            stmt.executeBatch();
            return stmt.getUpdateCount();
        }
        long rv = 0L;
        for (int i : stmt.executeBatch()) {
            rv += (long)i;
        }
        return rv;
    }

    protected void close(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    protected void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }
}

