/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.google.common.collect.ImmutableList;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.StoreClause;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.EmptyResultSet;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLMergeBatch;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.util.ResultSetAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLMergeClause
extends AbstractSQLClause<SQLMergeClause>
implements StoreClause<SQLMergeClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLMergeClause.class);
    private final List<Path<?>> columns = new ArrayList();
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final List<Path<?>> keys = new ArrayList();
    @Nullable
    private SubQueryExpression<?> subQuery;
    private final List<SQLMergeBatch> batches = new ArrayList<SQLMergeBatch>();
    private final List<Expression<?>> values = new ArrayList();
    private transient String queryString;

    public SQLMergeClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLMergeClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLMergeClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLMergeClause addBatch() {
        if (!this.configuration.getTemplates().isNativeMerge()) {
            throw new IllegalStateException("batch only supported for databases that support native merge");
        }
        this.batches.add(new SQLMergeBatch(this.keys, this.columns, this.values, this.subQuery));
        this.columns.clear();
        this.values.clear();
        this.keys.clear();
        this.subQuery = null;
        return this;
    }

    public SQLMergeClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    @Nullable
    public <T> T executeWithKey(Path<T> path) {
        return this.executeWithKey(path.getType(), path);
    }

    public <T> T executeWithKey(Class<T> type) {
        return this.executeWithKey(type, null);
    }

    private <T> T executeWithKey(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            if (rs.next()) {
                T t = this.configuration.get(rs, path, 1, type);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(rs);
        }
    }

    public <T> List<T> executeWithKeys(Path<T> path) {
        return this.executeWithKeys(path.getType(), path);
    }

    public <T> List<T> executeWithKeys(Class<T> type) {
        return this.executeWithKeys(type, null);
    }

    private <T> List<T> executeWithKeys(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            ArrayList<T> rv = new ArrayList<T>();
            while (rs.next()) {
                rv.add(this.configuration.get(rs, path, 1, type));
            }
            ArrayList<T> arrayList = rv;
            return arrayList;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(rs);
        }
    }

    public ResultSet executeWithKeys() {
        try {
            if (this.configuration.getTemplates().isNativeMerge()) {
                final PreparedStatement stmt = this.createStatement(true);
                if (this.batches.isEmpty()) {
                    this.listeners.notifyMerge(this.entity, this.metadata, this.keys, this.columns, this.values, this.subQuery);
                    stmt.executeUpdate();
                } else {
                    this.listeners.notifyMerges(this.entity, this.metadata, this.batches);
                    stmt.executeBatch();
                }
                ResultSet rs = stmt.getGeneratedKeys();
                return new ResultSetAdapter(rs){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws SQLException {
                        try {
                            super.close();
                        }
                        finally {
                            stmt.close();
                        }
                    }
                };
            }
            List<?> ids = this.getIds();
            if (!ids.isEmpty()) {
                SQLUpdateClause update = new SQLUpdateClause(this.connection, this.configuration.getTemplates(), this.entity);
                this.populate((StoreClause<?>)update);
                update.where(ExpressionUtils.in((Expression)((Expression)this.keys.get(0)), ids));
                return EmptyResultSet.DEFAULT;
            }
            SQLInsertClause insert = new SQLInsertClause(this.connection, this.configuration.getTemplates(), this.entity);
            this.populate((StoreClause<?>)insert);
            return insert.executeWithKeys();
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
    }

    public long execute() {
        if (this.configuration.getTemplates().isNativeMerge()) {
            return this.executeNativeMerge();
        }
        return this.executeCompositeMerge();
    }

    @Override
    public List<SQLBindings> getSQL() {
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = new SQLSerializer(this.configuration, true);
            serializer.serializeForMerge(this.metadata, this.entity, this.keys, this.columns, this.values, this.subQuery);
            return ImmutableList.of((Object)this.createBindings(this.metadata, serializer));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLMergeBatch batch : this.batches) {
            SQLSerializer serializer = new SQLSerializer(this.configuration, true);
            serializer.serializeForMerge(this.metadata, this.entity, batch.getKeys(), batch.getColumns(), batch.getValues(), batch.getSubQuery());
            builder.add((Object)this.createBindings(this.metadata, serializer));
        }
        return builder.build();
    }

    private List<?> getIds() {
        SQLQuery query = (SQLQuery)new SQLQuery(this.connection, this.configuration.getTemplates()).from((Expression<?>)this.entity);
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.values.get(i) instanceof NullExpression) {
                query.where(ExpressionUtils.isNull((Expression)((Expression)this.columns.get(i))));
                continue;
            }
            query.where(ExpressionUtils.eq((Expression)((Expression)this.columns.get(i)), this.values.get(i)));
        }
        List ids = query.list((Expression)this.keys.get(0));
        return ids;
    }

    private long executeCompositeMerge() {
        List<?> ids = this.getIds();
        if (!ids.isEmpty()) {
            SQLUpdateClause update = new SQLUpdateClause(this.connection, this.configuration.getTemplates(), this.entity);
            this.populate((StoreClause<?>)update);
            update.where(ExpressionUtils.in((Expression)((Expression)this.keys.get(0)), ids));
            return update.execute();
        }
        SQLInsertClause insert = new SQLInsertClause(this.connection, this.configuration.getTemplates(), this.entity);
        this.populate((StoreClause<?>)insert);
        return insert.execute();
    }

    private void populate(StoreClause<?> clause) {
        for (int i = 0; i < this.columns.size(); ++i) {
            clause.set(this.columns.get(i), this.values.get(i));
        }
    }

    private PreparedStatement createStatement(boolean withKeys) throws SQLException {
        SQLSerializer serializer = new SQLSerializer(this.configuration, true);
        PreparedStatement stmt = null;
        if (this.batches.isEmpty()) {
            serializer.serializeForMerge(this.metadata, this.entity, this.keys, this.columns, this.values, this.subQuery);
            stmt = this.prepareStatementAndSetParameters(serializer, withKeys);
        } else {
            serializer.serializeForMerge(this.metadata, this.entity, this.batches.get(0).getKeys(), this.batches.get(0).getColumns(), this.batches.get(0).getValues(), this.batches.get(0).getSubQuery());
            stmt = this.prepareStatementAndSetParameters(serializer, withKeys);
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                SQLMergeBatch batch = this.batches.get(i);
                serializer = new SQLSerializer(this.configuration, true);
                serializer.serializeForMerge(this.metadata, this.entity, batch.getKeys(), batch.getColumns(), batch.getValues(), batch.getSubQuery());
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    private PreparedStatement prepareStatementAndSetParameters(SQLSerializer serializer, boolean withKeys) throws SQLException {
        PreparedStatement stmt;
        this.queryString = serializer.toString();
        logger.debug(this.queryString);
        if (withKeys) {
            String[] target = new String[this.keys.size()];
            for (int i = 0; i < target.length; ++i) {
                target[i] = ColumnMetadata.getName(this.keys.get(i));
            }
            stmt = this.connection.prepareStatement(this.queryString, target);
        } else {
            stmt = this.connection.prepareStatement(this.queryString);
        }
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        return stmt;
    }

    private long executeNativeMerge() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement(false);
            if (this.batches.isEmpty()) {
                this.listeners.notifyMerge(this.entity, this.metadata, this.keys, this.columns, this.values, this.subQuery);
                long l = stmt.executeUpdate();
                return l;
            }
            this.listeners.notifyMerges(this.entity, this.metadata, this.batches);
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLMergeClause keys(Path<?> ... paths) {
        for (Path<?> path : paths) {
            this.keys.add(path);
        }
        return this;
    }

    public SQLMergeClause select(SubQueryExpression<?> subQuery) {
        this.subQuery = subQuery;
        return this;
    }

    public <T> SQLMergeClause set(Path<T> path, @Nullable T value) {
        this.columns.add(path);
        if (value != null) {
            this.values.add((Expression<?>)new ConstantImpl(value));
        } else {
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public <T> SQLMergeClause set(Path<T> path, Expression<? extends T> expression) {
        this.columns.add(path);
        this.values.add(expression);
        return this;
    }

    public <T> SQLMergeClause setNull(Path<T> path) {
        this.columns.add(path);
        this.values.add((Expression<?>)Null.CONSTANT);
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration, true);
        serializer.serializeForMerge(this.metadata, this.entity, this.keys, this.columns, this.values, this.subQuery);
        return serializer.toString();
    }

    public SQLMergeClause values(Object ... v) {
        for (Object value : v) {
            if (value instanceof Expression) {
                this.values.add((Expression)value);
                continue;
            }
            if (value != null) {
                this.values.add((Expression<?>)new ConstantImpl(value));
                continue;
            }
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

