/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;

public class SQLServerTemplates
extends SQLTemplates {
    private String topTemplate = "top {0s} ";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new SQLServerTemplates(escape, quote);
            }
        };
    }

    public SQLServerTemplates() {
        this('\\', false);
    }

    public SQLServerTemplates(boolean quote) {
        this('\\', quote);
    }

    public SQLServerTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.addClass2TypeMappings("decimal", Double.class);
        this.setDummyTable("");
        this.setNullsFirst(null);
        this.setNullsLast(null);
        this.add(Ops.CONCAT, "{0} + {1}", 13);
        this.add(Ops.CHAR_AT, "cast(substring({0},{1}+1,1) as char)");
        this.add(Ops.INDEX_OF, "charindex({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "charindex({1},{0},{2})-1");
        this.add(Ops.MATCHES, "{0} like {1}");
        this.add(Ops.STRING_IS_EMPTY, "len({0}) = 0");
        this.add(Ops.STRING_LENGTH, "len({0})");
        this.add(Ops.SUBSTR_1ARG, "substring({0},{1}+1,255)");
        this.add(Ops.SUBSTR_2ARGS, "substring({0},{1}+1,{2})");
        this.add(Ops.TRIM, "ltrim(rtrim({0}))");
        this.add(Ops.StringOps.LOCATE, "charindex({0},{1})");
        this.add(Ops.StringOps.LOCATE2, "charindex({0},{1},{2})");
        this.add(SQLOps.NEXTVAL, "{0s}.nextval");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.YEAR, "datepart(year, {0})");
        this.add(Ops.DateTimeOps.MONTH, "datepart(month, {0})");
        this.add(Ops.DateTimeOps.WEEK, "datepart(week, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "datepart(day, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "datepart(weekday, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "datepart(dayofyear, {0})");
        this.add(Ops.DateTimeOps.HOUR, "datepart(hour, {0})");
        this.add(Ops.DateTimeOps.MINUTE, "datepart(minute, {0})");
        this.add(Ops.DateTimeOps.SECOND, "datepart(second, {0})");
        this.add(Ops.DateTimeOps.MILLISECOND, "datepart(millisecond, {0})");
        this.add(Ops.DateTimeOps.YEAR_WEEK, "(datepart(year, {0}) * 100 + datepart(isowk, {0}))");
        this.add(Ops.DateTimeOps.ADD_YEARS, "dateadd(year, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "dateadd(month, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "dateadd(week, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_DAYS, "dateadd(day, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_HOURS, "dateadd(hour, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "dateadd(minute, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "dateadd(second, {1s}, {0})");
        this.add(Ops.DateTimeOps.DIFF_YEARS, "datediff(year,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MONTHS, "datediff(month,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_WEEKS, "datediff(week,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_DAYS, "datediff(day,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_HOURS, "datediff(hour,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MINUTES, "datediff(minute,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_SECONDS, "datediff(second,{0},{1})");
        this.add(Ops.DateTimeOps.DATE, "cast({0} as date)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            QueryModifiers mod = metadata.getModifiers();
            if (mod.getOffset() != null) throw new IllegalStateException("offset not supported");
            metadata = metadata.clone();
            metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Integer.class, (String)this.topTemplate, (Object[])new Object[]{mod.getLimit()})));
            context.serializeForQuery(metadata, forCountRow);
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
        if (metadata.getFlags().isEmpty()) return;
        context.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
    }
}

