/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.mysql;

import com.google.common.base.Joiner;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLTemplates;
import java.io.File;
import java.sql.Connection;

public class MySQLQuery
extends AbstractSQLQuery<MySQLQuery>
implements SQLCommonQuery<MySQLQuery> {
    private static final String WITH_ROLLUP = "\nwith rollup ";
    private static final String STRAIGHT_JOIN = "straight_join ";
    private static final String SQL_SMALL_RESULT = "sql_small_result ";
    private static final String SQL_NO_CACHE = "sql_no_cache ";
    private static final String LOCK_IN_SHARE_MODE = "\nlock in share mode ";
    private static final String HIGH_PRIORITY = "high_priority ";
    private static final String SQL_CALC_FOUND_ROWS = "sql_calc_found_rows ";
    private static final String SQL_CACHE = "sql_cache ";
    private static final String SQL_BUFFER_RESULT = "sql_buffer_result ";
    private static final String SQL_BIG_RESULT = "sql_big_result ";
    private static final Joiner JOINER = Joiner.on((String)", ");

    public MySQLQuery(Connection conn) {
        this(conn, new Configuration(new MySQLTemplates()), (QueryMetadata)new DefaultQueryMetadata());
    }

    public MySQLQuery(Connection conn, SQLTemplates templates) {
        this(conn, new Configuration(templates), (QueryMetadata)new DefaultQueryMetadata());
    }

    public MySQLQuery(Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata());
    }

    public MySQLQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public MySQLQuery bigResult() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_BIG_RESULT);
    }

    public MySQLQuery bufferResult() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_BUFFER_RESULT);
    }

    public MySQLQuery cache() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_CACHE);
    }

    public MySQLQuery calcFoundRows() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_CALC_FOUND_ROWS);
    }

    public MySQLQuery highPriority() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, HIGH_PRIORITY);
    }

    public MySQLQuery into(String var) {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto " + var);
    }

    public MySQLQuery intoDumpfile(File file) {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto dumpfile '" + file.getPath() + "'");
    }

    public MySQLQuery intoOutfile(File file) {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto outfile '" + file.getPath() + "'");
    }

    public MySQLQuery lockInShareMode() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.END, LOCK_IN_SHARE_MODE);
    }

    public MySQLQuery noCache() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_NO_CACHE);
    }

    public MySQLQuery smallResult() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_SMALL_RESULT);
    }

    public MySQLQuery straightJoin() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, STRAIGHT_JOIN);
    }

    public MySQLQuery forceIndex(String ... indexes) {
        return (MySQLQuery)this.addJoinFlag(" force index (" + JOINER.join((Object[])indexes) + ")", JoinFlag.Position.END);
    }

    public MySQLQuery ignoreIndex(String ... indexes) {
        return (MySQLQuery)this.addJoinFlag(" ignore index (" + JOINER.join((Object[])indexes) + ")", JoinFlag.Position.END);
    }

    public MySQLQuery useIndex(String ... indexes) {
        return (MySQLQuery)this.addJoinFlag(" use index (" + JOINER.join((Object[])indexes) + ")", JoinFlag.Position.END);
    }

    public MySQLQuery withRollup() {
        return (MySQLQuery)this.addFlag(QueryFlag.Position.AFTER_GROUP_BY, WITH_ROLLUP);
    }
}

