/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.types;

import com.mysema.query.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

public class LocalTimeType
extends AbstractType<LocalTime> {
    public LocalTimeType() {
        super(92);
    }

    public LocalTimeType(int type) {
        super(type);
    }

    @Override
    public Class<LocalTime> getReturnedClass() {
        return LocalTime.class;
    }

    @Override
    public LocalTime getValue(ResultSet rs, int startIndex) throws SQLException {
        Time time = rs.getTime(startIndex, LocalTimeType.utc());
        return time != null ? new LocalTime(time.getTime(), DateTimeZone.UTC) : null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, LocalTime value) throws SQLException {
        st.setTime(startIndex, new Time(value.getMillisOfDay()), LocalTimeType.utc());
    }
}

