/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class H2Templates
extends SQLTemplates {
    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new H2Templates(escape, quote);
            }
        };
    }

    public H2Templates() {
        this('\\', false);
    }

    public H2Templates(boolean quote) {
        this('\\', quote);
    }

    public H2Templates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setNativeMerge(true);
        this.setLimitRequired(true);
        this.setCountDistinctMultipleColumns(true);
        this.add(Ops.MathOps.ROUND, "round({0},0)");
        this.add(Ops.TRIM, "trim(both from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "day_of_week({0})");
        this.add(Ops.MathOps.LN, "log({0})");
        this.add(Ops.MathOps.LOG, "(log({0}) / log({1}))");
        this.add(Ops.MathOps.COTH, "(cosh({0}) / sinh({0}))");
        this.add(Ops.DateTimeOps.DATE, "convert({0}, date)");
    }
}

