/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.AbstractSQLQueryFactory;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLTemplates;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Provider;
import javax.sql.DataSource;

public class SQLQueryFactory
extends AbstractSQLQueryFactory<SQLQuery> {
    public SQLQueryFactory(SQLTemplates templates, Provider<Connection> connection) {
        this(new Configuration(templates), connection);
    }

    public SQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        super(configuration, connection);
    }

    public SQLQueryFactory(Configuration configuration, DataSource dataSource) {
        super(configuration, new DataSourceProvider(dataSource));
    }

    @Override
    public SQLQuery query() {
        return new SQLQuery((Connection)this.connection.get(), this.configuration);
    }

    static class DataSourceProvider
    implements Provider<Connection> {
        private final DataSource ds;

        public DataSourceProvider(DataSource ds) {
            this.ds = ds;
        }

        public Connection get() {
            try {
                return this.ds.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

