/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLSubQuery;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.CollectionExpressionBase;
import com.mysema.query.types.expr.CollectionOperation;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import java.util.Arrays;
import java.util.List;

public class SQLSubQuery
extends AbstractSQLSubQuery<SQLSubQuery> {
    public SQLSubQuery() {
    }

    public SQLSubQuery(QueryMetadata metadata) {
        super(metadata);
    }

    private <T> CollectionExpressionBase<?, T> union(Operator<Object> op, List<? extends SubQueryExpression<?>> sq) {
        Expression rv = (Expression)sq.get(0);
        if (sq.size() == 1 && !CollectionExpression.class.isInstance(rv)) {
            return new ListSubQuery(rv.getType(), sq.get(0).getMetadata());
        }
        Class elementType = sq.get(0).getType();
        if (rv instanceof CollectionExpression) {
            elementType = ((CollectionExpression)rv).getParameter(0);
        }
        for (int i = 1; i < sq.size(); ++i) {
            rv = CollectionOperation.create(op, (Class)elementType, (Expression)rv, (Expression)((Expression)sq.get(i)));
        }
        return (CollectionExpressionBase)rv;
    }

    public <T> CollectionExpressionBase<?, T> union(List<? extends SubQueryExpression<T>> sq) {
        return this.union(SQLOps.UNION, sq);
    }

    public <T> CollectionExpressionBase<?, T> union(ListSubQuery<T> ... sq) {
        return this.union(SQLOps.UNION, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> union(SubQueryExpression<T> ... sq) {
        return this.union(SQLOps.UNION, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> unionAll(List<? extends SubQueryExpression<T>> sq) {
        return this.union(SQLOps.UNION_ALL, sq);
    }

    public <T> CollectionExpressionBase<?, T> unionAll(ListSubQuery<T> ... sq) {
        return this.union(SQLOps.UNION_ALL, Arrays.asList(sq));
    }

    public <T> CollectionExpressionBase<?, T> unionAll(SubQueryExpression<T> ... sq) {
        return this.union(SQLOps.UNION_ALL, Arrays.asList(sq));
    }

    public BooleanExpression exists() {
        return this.unique(NumberTemplate.ONE).exists();
    }

    public BooleanExpression notExists() {
        return this.exists().not();
    }
}

