/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.PrimaryKey;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.RelationalPathUtils;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.path.BeanPath;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RelationalPathBase<T>
extends BeanPath<T>
implements RelationalPath<T> {
    private static final long serialVersionUID = -7031357250283629202L;
    @Nullable
    private PrimaryKey<T> primaryKey;
    private final Map<Path<?>, ColumnMetadata> columnMetadata = Maps.newLinkedHashMap();
    private final List<ForeignKey<?>> foreignKeys = Lists.newArrayList();
    private final List<ForeignKey<?>> inverseForeignKeys = Lists.newArrayList();
    private final String schema;
    private final String table;
    private transient FactoryExpression<T> projection;
    private transient NumberExpression<Long> count;
    private transient NumberExpression<Long> countDistinct;

    public RelationalPathBase(Class<? extends T> type, String variable, String schema, String table) {
        this(type, PathMetadataFactory.forVariable((String)variable), schema, table);
    }

    public RelationalPathBase(Class<? extends T> type, PathMetadata<?> metadata, String schema, String table) {
        super(type, metadata);
        this.schema = schema;
        this.table = table;
    }

    protected PrimaryKey<T> createPrimaryKey(Path<?> ... columns) {
        this.primaryKey = new PrimaryKey(this, columns);
        return this.primaryKey;
    }

    protected <F> ForeignKey<F> createForeignKey(Path<?> local, String foreign) {
        ForeignKey foreignKey = new ForeignKey(this, local, foreign);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createForeignKey(List<? extends Path<?>> local, List<String> foreign) {
        ForeignKey foreignKey = new ForeignKey(this, ImmutableList.copyOf(local), (ImmutableList<String>)ImmutableList.copyOf(foreign));
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createInvForeignKey(Path<?> local, String foreign) {
        ForeignKey foreignKey = new ForeignKey(this, local, foreign);
        this.inverseForeignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createInvForeignKey(List<? extends Path<?>> local, List<String> foreign) {
        ForeignKey foreignKey = new ForeignKey(this, ImmutableList.copyOf(local), (ImmutableList<String>)ImmutableList.copyOf(foreign));
        this.inverseForeignKeys.add(foreignKey);
        return foreignKey;
    }

    protected <P extends Path<?>> P addMetadata(P path, ColumnMetadata metadata) {
        this.columnMetadata.put(path, metadata);
        return path;
    }

    public NumberExpression<Long> count() {
        if (this.count == null) {
            if (this.primaryKey != null) {
                this.count = NumberOperation.create(Long.class, (Operator)Ops.AggOps.COUNT_AGG, (Expression)((Expression)this.primaryKey.getLocalColumns().get(0)));
            } else {
                throw new IllegalStateException("No count expression can be created");
            }
        }
        return this.count;
    }

    public NumberExpression<Long> countDistinct() {
        if (this.countDistinct == null) {
            if (this.primaryKey != null) {
                this.countDistinct = NumberOperation.create(Long.class, (Operator)Ops.AggOps.COUNT_DISTINCT_AGG, (Expression)((Expression)this.primaryKey.getLocalColumns().get(0)));
            } else {
                throw new IllegalStateException("No count distinct expression can be created");
            }
        }
        return this.countDistinct;
    }

    public FactoryExpression<T> getProjection() {
        if (this.projection == null) {
            this.projection = RelationalPathUtils.createProjection(this);
        }
        return this.projection;
    }

    public Path<?>[] all() {
        Path[] all = new Path[this.columnMetadata.size()];
        this.columnMetadata.keySet().toArray(all);
        return all;
    }

    protected <P extends Path<?>> P add(P path) {
        return path;
    }

    @Override
    public List<Path<?>> getColumns() {
        return Lists.newArrayList(this.columnMetadata.keySet());
    }

    @Override
    public Collection<ForeignKey<?>> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Collection<ForeignKey<?>> getInverseForeignKeys() {
        return this.inverseForeignKeys;
    }

    @Override
    public PrimaryKey<T> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public String getTableName() {
        return this.table;
    }

    @Override
    public ColumnMetadata getMetadata(Path<?> column) {
        return this.columnMetadata.get(column);
    }
}

