/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.Lists;
import com.mysema.commons.lang.Pair;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.dml.SQLInsertBatch;
import com.mysema.query.sql.dml.SQLMergeBatch;
import com.mysema.query.sql.dml.SQLUpdateBatch;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import java.util.List;
import javax.annotation.Nullable;

public class SQLListeners
implements SQLListener {
    @Nullable
    private final SQLListener parent;
    private final List<SQLListener> listeners = Lists.newArrayList();

    public SQLListeners(SQLListener parent) {
        this.parent = parent;
    }

    public SQLListeners() {
        this.parent = null;
    }

    public void add(SQLListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void notifyQuery(QueryMetadata md) {
        if (this.parent != null) {
            this.parent.notifyQuery(md);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyQuery(md);
        }
    }

    @Override
    public void notifyDelete(RelationalPath<?> entity, QueryMetadata md) {
        if (this.parent != null) {
            this.parent.notifyDelete(entity, md);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyDelete(entity, md);
        }
    }

    @Override
    public void notifyDeletes(RelationalPath<?> entity, List<QueryMetadata> batches) {
        if (this.parent != null) {
            this.parent.notifyDeletes(entity, batches);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyDeletes(entity, batches);
        }
    }

    @Override
    public void notifyMerge(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (this.parent != null) {
            this.parent.notifyMerge(entity, md, keys, columns, values, subQuery);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyMerge(entity, md, keys, columns, values, subQuery);
        }
    }

    @Override
    public void notifyMerges(RelationalPath<?> entity, QueryMetadata md, List<SQLMergeBatch> batches) {
        if (this.parent != null) {
            this.parent.notifyMerges(entity, md, batches);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyMerges(entity, md, batches);
        }
    }

    @Override
    public void notifyInsert(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (this.parent != null) {
            this.parent.notifyInsert(entity, md, columns, values, subQuery);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyInsert(entity, md, columns, values, subQuery);
        }
    }

    @Override
    public void notifyInserts(RelationalPath<?> entity, QueryMetadata md, List<SQLInsertBatch> batches) {
        if (this.parent != null) {
            this.parent.notifyInserts(entity, md, batches);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyInserts(entity, md, batches);
        }
    }

    @Override
    public void notifyUpdate(RelationalPath<?> entity, QueryMetadata md, List<Pair<Path<?>, Expression<?>>> updates) {
        if (this.parent != null) {
            this.parent.notifyUpdate(entity, md, updates);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyUpdate(entity, md, updates);
        }
    }

    @Override
    public void notifyUpdates(RelationalPath<?> entity, List<SQLUpdateBatch> batches) {
        if (this.parent != null) {
            this.parent.notifyUpdates(entity, batches);
        }
        for (SQLListener listener : this.listeners) {
            listener.notifyUpdates(entity, batches);
        }
    }
}

