/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.google.common.collect.ImmutableList;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.InsertClause;
import com.mysema.query.sql.AbstractSQLSubQuery;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.DefaultMapper;
import com.mysema.query.sql.dml.Mapper;
import com.mysema.query.sql.dml.SQLInsertBatch;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.util.ResultSetAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInsertClause
extends AbstractSQLClause<SQLInsertClause>
implements InsertClause<SQLInsertClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInsertClause.class);
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    @Nullable
    private SubQueryExpression<?> subQuery;
    @Nullable
    private AbstractSQLSubQuery<?> subQueryBuilder;
    private final List<SQLInsertBatch> batches = new ArrayList<SQLInsertBatch>();
    private final List<Path<?>> columns = new ArrayList();
    private final List<Expression<?>> values = new ArrayList();
    private transient String queryString;
    private transient List<Object> constants;

    public SQLInsertClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLInsertClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity, AbstractSQLSubQuery<?> subQuery) {
        this(connection, new Configuration(templates), entity);
        this.subQueryBuilder = subQuery;
    }

    public SQLInsertClause(Connection connection, Configuration configuration, RelationalPath<?> entity, AbstractSQLSubQuery<?> subQuery) {
        this(connection, configuration, entity);
        this.subQueryBuilder = subQuery;
    }

    public SQLInsertClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLInsertClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLInsertClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLInsertClause addBatch() {
        if (this.subQueryBuilder != null) {
            this.subQuery = this.subQueryBuilder.list(this.values.toArray(new Expression[this.values.size()]));
            this.values.clear();
        }
        this.batches.add(new SQLInsertBatch(this.columns, this.values, this.subQuery));
        this.columns.clear();
        this.values.clear();
        this.subQuery = null;
        return this;
    }

    public SQLInsertClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    @Nullable
    public <T> T executeWithKey(Path<T> path) {
        return this.executeWithKey(path.getType(), path);
    }

    public <T> T executeWithKey(Class<T> type) {
        return this.executeWithKey(type, null);
    }

    private <T> T executeWithKey(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            if (rs.next()) {
                T t = this.configuration.get(rs, path, 1, type);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException e) {
            throw this.configuration.translate(e);
        }
        finally {
            this.close(rs);
        }
    }

    public <T> List<T> executeWithKeys(Path<T> path) {
        return this.executeWithKeys(path.getType(), path);
    }

    public <T> List<T> executeWithKeys(Class<T> type) {
        return this.executeWithKeys(type, null);
    }

    private <T> List<T> executeWithKeys(Class<T> type, @Nullable Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            ArrayList<T> rv = new ArrayList<T>();
            while (rs.next()) {
                rv.add(this.configuration.get(rs, path, 1, type));
            }
            ArrayList<T> arrayList = rv;
            return arrayList;
        }
        catch (SQLException e) {
            throw this.configuration.translate(e);
        }
        finally {
            this.close(rs);
        }
    }

    private PreparedStatement createStatement(boolean withKeys) throws SQLException {
        SQLSerializer serializer = this.createSerializer();
        if (this.subQueryBuilder != null) {
            this.subQuery = this.subQueryBuilder.list(this.values.toArray(new Expression[this.values.size()]));
            this.values.clear();
        }
        PreparedStatement stmt = null;
        if (this.batches.isEmpty()) {
            serializer.serializeInsert(this.metadata, this.entity, this.columns, this.values, this.subQuery);
            stmt = this.prepareStatementAndSetParameters(serializer, withKeys);
        } else {
            serializer.serializeInsert(this.metadata, this.entity, this.batches.get(0).getColumns(), this.batches.get(0).getValues(), this.batches.get(0).getSubQuery());
            stmt = this.prepareStatementAndSetParameters(serializer, withKeys);
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                SQLInsertBatch batch = this.batches.get(i);
                serializer = this.createSerializer();
                serializer.serializeInsert(this.metadata, this.entity, batch.getColumns(), batch.getValues(), batch.getSubQuery());
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    private PreparedStatement prepareStatementAndSetParameters(SQLSerializer serializer, boolean withKeys) throws SQLException {
        PreparedStatement stmt;
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        logger.debug(this.queryString);
        if (withKeys) {
            if (this.entity.getPrimaryKey() != null) {
                String[] target = new String[this.entity.getPrimaryKey().getLocalColumns().size()];
                for (int i = 0; i < target.length; ++i) {
                    String column;
                    Path<?> path = this.entity.getPrimaryKey().getLocalColumns().get(i);
                    target[i] = column = ColumnMetadata.getName(path);
                }
                stmt = this.connection.prepareStatement(this.queryString, target);
            } else {
                stmt = this.connection.prepareStatement(this.queryString, 1);
            }
        } else {
            stmt = this.connection.prepareStatement(this.queryString);
        }
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        return stmt;
    }

    public ResultSet executeWithKeys() {
        try {
            final PreparedStatement stmt = this.createStatement(true);
            if (this.batches.isEmpty()) {
                this.listeners.notifyInsert(this.entity, this.metadata, this.columns, this.values, this.subQuery);
                stmt.executeUpdate();
            } else {
                this.listeners.notifyInserts(this.entity, this.metadata, this.batches);
                stmt.executeBatch();
            }
            ResultSet rs = stmt.getGeneratedKeys();
            return new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
        }
        catch (SQLException e) {
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
    }

    public long execute() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement(false);
            if (this.batches.isEmpty()) {
                this.listeners.notifyInsert(this.entity, this.metadata, this.columns, this.values, this.subQuery);
                long l = stmt.executeUpdate();
                return l;
            }
            this.listeners.notifyInserts(this.entity, this.metadata, this.batches);
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    @Override
    public List<SQLBindings> getSQL() {
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeInsert(this.metadata, this.entity, this.columns, this.values, this.subQuery);
            return ImmutableList.of((Object)this.createBindings(this.metadata, serializer));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLInsertBatch batch : this.batches) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeInsert(this.metadata, this.entity, batch.getColumns(), batch.getValues(), batch.getSubQuery());
            builder.add((Object)this.createBindings(this.metadata, serializer));
        }
        return builder.build();
    }

    public SQLInsertClause select(SubQueryExpression<?> sq) {
        this.subQuery = sq;
        for (Map.Entry entry : sq.getMetadata().getParams().entrySet()) {
            this.metadata.setParam((ParamExpression)entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T> SQLInsertClause set(Path<T> path, T value) {
        this.columns.add(path);
        if (value instanceof Expression) {
            this.values.add((Expression)value);
        } else if (value != null) {
            this.values.add((Expression<?>)ConstantImpl.create(value));
        } else {
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public <T> SQLInsertClause set(Path<T> path, Expression<? extends T> expression) {
        this.columns.add(path);
        this.values.add(expression);
        return this;
    }

    public <T> SQLInsertClause setNull(Path<T> path) {
        this.columns.add(path);
        this.values.add((Expression<?>)Null.CONSTANT);
        return this;
    }

    public SQLInsertClause values(Object ... v) {
        for (Object value : v) {
            if (value instanceof Expression) {
                this.values.add((Expression)value);
                continue;
            }
            if (value != null) {
                this.values.add((Expression<?>)ConstantImpl.create((Object)value));
                continue;
            }
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeInsert(this.metadata, this.entity, this.columns, this.values, this.subQuery);
        return serializer.toString();
    }

    public SQLInsertClause populate(Object bean) {
        return this.populate(bean, DefaultMapper.DEFAULT);
    }

    public <T> SQLInsertClause populate(T obj, Mapper<T> mapper) {
        Map<Path<?>, Object> values = mapper.createMap(this.entity, obj);
        for (Map.Entry<Path<?>, Object> entry : values.entrySet()) {
            this.set((Path<T>)entry.getKey(), (T)entry.getValue());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.values.isEmpty() && this.batches.isEmpty();
    }
}

