/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.google.common.collect.ImmutableList;
import com.mysema.commons.lang.Pair;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.DefaultMapper;
import com.mysema.query.sql.dml.Mapper;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLUpdateBatch;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUpdateClause
extends AbstractSQLClause<SQLUpdateClause>
implements UpdateClause<SQLUpdateClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInsertClause.class);
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final List<SQLUpdateBatch> batches = new ArrayList<SQLUpdateBatch>();
    private List<Pair<Path<?>, Expression<?>>> updates = new ArrayList();
    private QueryMetadata metadata = new DefaultQueryMetadata();
    private transient String queryString;
    private transient List<Object> constants;

    public SQLUpdateClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLUpdateClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLUpdateClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLUpdateClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLUpdateClause addBatch() {
        this.assertNoTemplateExpressionsInBatch();
        this.batches.add(new SQLUpdateBatch(this.metadata, this.updates));
        this.updates = new ArrayList();
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        return this;
    }

    @Override
    protected void assertNoTemplateExpressionsInBatch() {
        for (Pair<Path<?>, Expression<?>> pair : this.updates) {
            this.assertNoTemplateExpressionInBatch((Expression)pair.getSecond());
        }
        this.assertNoTemplateExpressionInBatch((Expression<?>)this.metadata.getWhere());
    }

    private PreparedStatement createStatement() throws SQLException {
        PreparedStatement stmt;
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeUpdate(this.metadata, this.entity, this.updates);
            this.queryString = serializer.toString();
            this.constants = serializer.getConstants();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        } else {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeUpdate(this.batches.get(0).getMetadata(), this.entity, this.batches.get(0).getUpdates());
            this.queryString = serializer.toString();
            this.constants = serializer.getConstants();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                serializer = this.createSerializer();
                serializer.serializeUpdate(this.batches.get(i).getMetadata(), this.entity, this.batches.get(i).getUpdates());
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    public long execute() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement();
            if (this.batches.isEmpty()) {
                this.listeners.notifyUpdate(this.entity, this.metadata, this.updates);
                long l = stmt.executeUpdate();
                return l;
            }
            this.listeners.notifyUpdates(this.entity, this.batches);
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    @Override
    public List<SQLBindings> getSQL() {
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeUpdate(this.metadata, this.entity, this.updates);
            return ImmutableList.of((Object)this.createBindings(this.metadata, serializer));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLUpdateBatch batch : this.batches) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeUpdate(batch.getMetadata(), this.entity, batch.getUpdates());
            builder.add((Object)this.createBindings(this.metadata, serializer));
        }
        return builder.build();
    }

    public <T> SQLUpdateClause set(Path<T> path, T value) {
        if (value instanceof Expression) {
            this.updates.add(Pair.of(path, (Object)((Expression)value)));
        } else if (value != null) {
            this.updates.add(Pair.of(path, (Object)ConstantImpl.create(value)));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> SQLUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.updates.add(Pair.of(path, expression));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> SQLUpdateClause setNull(Path<T> path) {
        this.updates.add(Pair.of(path, Null.CONSTANT));
        return this;
    }

    public SQLUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) instanceof Expression) {
                this.updates.add(Pair.of(paths.get(i), (Object)((Expression)values.get(i))));
                continue;
            }
            if (values.get(i) != null) {
                this.updates.add(Pair.of(paths.get(i), (Object)ConstantImpl.create(values.get(i))));
                continue;
            }
            this.updates.add(Pair.of(paths.get(i), Null.CONSTANT));
        }
        return this;
    }

    public SQLUpdateClause where(Predicate p) {
        this.metadata.addWhere(p);
        return this;
    }

    public SQLUpdateClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.metadata.addWhere(p);
        }
        return this;
    }

    public SQLUpdateClause limit(@Nonnegative long limit) {
        this.metadata.setModifiers(QueryModifiers.limit((long)limit));
        return this;
    }

    public String toString() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeUpdate(this.metadata, this.entity, this.updates);
        return serializer.toString();
    }

    public SQLUpdateClause populate(Object bean) {
        return this.populate(bean, DefaultMapper.DEFAULT);
    }

    public <T> SQLUpdateClause populate(T obj, Mapper<T> mapper) {
        List primaryKeyColumns = this.entity.getPrimaryKey() != null ? this.entity.getPrimaryKey().getLocalColumns() : Collections.emptyList();
        Map<Path<?>, Object> values = mapper.createMap(this.entity, obj);
        for (Map.Entry<Path<?>, Object> entry : values.entrySet()) {
            if (primaryKeyColumns.contains(entry.getKey())) continue;
            this.set((Path<T>)entry.getKey(), (T)entry.getValue());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.updates.isEmpty() && this.batches.isEmpty();
    }
}

