/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.mysema.query.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;

public class MySQLWkbType
extends AbstractType<Geometry> {
    public static final MySQLWkbType DEFAULT = new MySQLWkbType();
    private final ByteOrder byteOrder = ByteOrder.NDR;

    public MySQLWkbType() {
        super(2004);
    }

    @Override
    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Override
    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            byte[] wkb = new byte[bytes.length - 4];
            System.arraycopy(bytes, 4, wkb, 0, wkb.length);
            int srid = bytes[3] << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
            WkbDecoder decoder = Wkb.newWkbDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(ByteBuffer.from((byte[])wkb));
        }
        return null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        WkbEncoder encoder = Wkb.newWkbEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        ByteBuffer buffer = encoder.encode(value, this.byteOrder);
        int srid = value.getSRID();
        byte[] wkb = buffer.toByteArray();
        byte[] bytes = new byte[wkb.length + 4];
        bytes[3] = (byte)(srid >> 24 & 0xFF);
        bytes[2] = (byte)(srid >> 16 & 0xFF);
        bytes[1] = (byte)(srid >> 8 & 0xFF);
        bytes[0] = (byte)(srid & 0xFF);
        System.arraycopy(wkb, 0, bytes, 4, wkb.length);
        st.setBytes(startIndex, bytes);
    }

    @Override
    public String getLiteral(Geometry geometry) {
        String str = Wkt.newWktEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode((Object)geometry);
        if (geometry.getSRID() > -1) {
            return "GeomFromText('" + str + "', " + geometry.getSRID() + ")";
        }
        return "GeomFromText('" + str + "')";
    }
}

