/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.google.common.collect.Maps;
import com.mysema.query.spatial.SpatialOps;
import com.mysema.query.types.Operator;
import java.util.HashMap;
import java.util.Map;

public final class SpatialTemplatesSupport {
    private static String createSpatial(String name, int args, boolean asFunction) {
        int start;
        StringBuilder result = new StringBuilder();
        if (!asFunction) {
            result.append("{0}.");
        }
        result.append(name);
        result.append("(");
        for (int i = start = asFunction ? 0 : 1; i < args; ++i) {
            if (i > start) {
                result.append(", ");
            }
            result.append("{" + i + "}");
        }
        result.append(")");
        return result.toString();
    }

    public static Map<Operator<?>, String> getSpatialOps(boolean asFunction) {
        return SpatialTemplatesSupport.getSpatialOps("ST_", asFunction);
    }

    public static Map<Operator<?>, String> getSpatialOps(String prefix, boolean asFunction) {
        HashMap ops = Maps.newHashMap();
        ops.put(SpatialOps.AREA, SpatialTemplatesSupport.createSpatial(prefix + "Area", 1, asFunction));
        ops.put(SpatialOps.AREA2, SpatialTemplatesSupport.createSpatial(prefix + "Area", 2, asFunction));
        ops.put(SpatialOps.AS_BINARY, SpatialTemplatesSupport.createSpatial(prefix + "AsBinary", 1, asFunction));
        ops.put(SpatialOps.AS_TEXT, SpatialTemplatesSupport.createSpatial(prefix + "AsText", 1, asFunction));
        ops.put(SpatialOps.BOUNDARY, SpatialTemplatesSupport.createSpatial(prefix + "Boundary", 1, asFunction));
        ops.put(SpatialOps.BUFFER, SpatialTemplatesSupport.createSpatial(prefix + "Buffer", 2, asFunction));
        ops.put(SpatialOps.BUFFER2, SpatialTemplatesSupport.createSpatial(prefix + "Buffer", 3, asFunction));
        ops.put(SpatialOps.CENTROID, SpatialTemplatesSupport.createSpatial(prefix + "Centroid", 1, asFunction));
        ops.put(SpatialOps.CONTAINS, SpatialTemplatesSupport.createSpatial(prefix + "Contains", 2, asFunction));
        ops.put(SpatialOps.CONVEXHULL, SpatialTemplatesSupport.createSpatial(prefix + "ConvexHull", 1, asFunction));
        ops.put(SpatialOps.CROSSES, SpatialTemplatesSupport.createSpatial(prefix + "Crosses", 2, asFunction));
        ops.put(SpatialOps.DIFFERENCE, SpatialTemplatesSupport.createSpatial(prefix + "Difference", 2, asFunction));
        ops.put(SpatialOps.DIMENSION, SpatialTemplatesSupport.createSpatial(prefix + "Dimension", 1, asFunction));
        ops.put(SpatialOps.DISJOINT, SpatialTemplatesSupport.createSpatial(prefix + "Disjoint", 2, asFunction));
        ops.put(SpatialOps.DISTANCE, SpatialTemplatesSupport.createSpatial(prefix + "Distance", 2, asFunction));
        ops.put(SpatialOps.DISTANCE2, SpatialTemplatesSupport.createSpatial(prefix + "Distance", 3, asFunction));
        ops.put(SpatialOps.END_POINT, SpatialTemplatesSupport.createSpatial(prefix + "EndPoint", 1, asFunction));
        ops.put(SpatialOps.ENVELOPE, SpatialTemplatesSupport.createSpatial(prefix + "Envelope", 1, asFunction));
        ops.put(SpatialOps.EQUALS, SpatialTemplatesSupport.createSpatial(prefix + "Equals", 2, asFunction));
        ops.put(SpatialOps.EXTERIOR_RING, SpatialTemplatesSupport.createSpatial(prefix + "ExteriorRing", 1, asFunction));
        ops.put(SpatialOps.EXTERIOR_RING2, SpatialTemplatesSupport.createSpatial(prefix + "ExteriorRing", 2, asFunction));
        ops.put(SpatialOps.GEOMETRIES, SpatialTemplatesSupport.createSpatial(prefix + "Geometries", 1, asFunction));
        ops.put(SpatialOps.GEOMETRY_TYPE, SpatialTemplatesSupport.createSpatial(prefix + "GeometryType", 1, asFunction));
        ops.put(SpatialOps.GEOMETRYN, SpatialTemplatesSupport.createSpatial(prefix + "GeometryN", 2, asFunction));
        ops.put(SpatialOps.INTERIOR_RINGN, SpatialTemplatesSupport.createSpatial(prefix + "InteriorRingN", 2, asFunction));
        ops.put(SpatialOps.INTERIOR_RINGS, SpatialTemplatesSupport.createSpatial(prefix + "InteriorRings", 1, asFunction));
        ops.put(SpatialOps.INTERIOR_RINGS2, SpatialTemplatesSupport.createSpatial(prefix + "InteriorRings", 2, asFunction));
        ops.put(SpatialOps.INTERSECTION, SpatialTemplatesSupport.createSpatial(prefix + "Intersection", 2, asFunction));
        ops.put(SpatialOps.INTERSECTS, SpatialTemplatesSupport.createSpatial(prefix + "Intersects", 2, asFunction));
        ops.put(SpatialOps.IS_CLOSED, SpatialTemplatesSupport.createSpatial(prefix + "IsClosed", 1, asFunction));
        ops.put(SpatialOps.IS_EMPTY, SpatialTemplatesSupport.createSpatial(prefix + "IsEmpty", 1, asFunction));
        ops.put(SpatialOps.IS_RING, SpatialTemplatesSupport.createSpatial(prefix + "IsRing", 1, asFunction));
        ops.put(SpatialOps.IS_SIMPLE, SpatialTemplatesSupport.createSpatial(prefix + "IsSimple", 1, asFunction));
        ops.put(SpatialOps.LENGTH, SpatialTemplatesSupport.createSpatial(prefix + "Length", 1, asFunction));
        ops.put(SpatialOps.LENGTH2, SpatialTemplatesSupport.createSpatial(prefix + "Length", 2, asFunction));
        ops.put(SpatialOps.M, SpatialTemplatesSupport.createSpatial(prefix + "M", 1, asFunction));
        ops.put(SpatialOps.M2, SpatialTemplatesSupport.createSpatial(prefix + "M", 2, asFunction));
        ops.put(SpatialOps.NUM_GEOMETRIES, SpatialTemplatesSupport.createSpatial(prefix + "NumGeometries", 1, asFunction));
        ops.put(SpatialOps.NUM_INTERIOR_RING, SpatialTemplatesSupport.createSpatial(prefix + "NumInteriorRing", 1, asFunction));
        ops.put(SpatialOps.NUM_POINTS, SpatialTemplatesSupport.createSpatial(prefix + "NumPoints", 1, asFunction));
        ops.put(SpatialOps.NUM_SURFACES, SpatialTemplatesSupport.createSpatial(prefix + "NumSurfaces", 1, asFunction));
        ops.put(SpatialOps.OVERLAPS, SpatialTemplatesSupport.createSpatial(prefix + "Overlaps", 2, asFunction));
        ops.put(SpatialOps.POINT_ON_SURFACE, SpatialTemplatesSupport.createSpatial(prefix + "PointOnSurface", 1, asFunction));
        ops.put(SpatialOps.POINTN, SpatialTemplatesSupport.createSpatial(prefix + "PointN", 2, asFunction));
        ops.put(SpatialOps.RELATE, SpatialTemplatesSupport.createSpatial(prefix + "Relate", 3, asFunction));
        ops.put(SpatialOps.SRID, SpatialTemplatesSupport.createSpatial(prefix + "SRID", 1, asFunction));
        ops.put(SpatialOps.SRID2, SpatialTemplatesSupport.createSpatial(prefix + "SRID", 2, asFunction));
        ops.put(SpatialOps.START_POINT, SpatialTemplatesSupport.createSpatial(prefix + "StartPoint", 1, asFunction));
        ops.put(SpatialOps.SURFACE, SpatialTemplatesSupport.createSpatial(prefix + "Surface", 1, asFunction));
        ops.put(SpatialOps.SYMDIFFERENCE, SpatialTemplatesSupport.createSpatial(prefix + "SymDifference", 2, asFunction));
        ops.put(SpatialOps.TOUCHES, SpatialTemplatesSupport.createSpatial(prefix + "Touches", 2, asFunction));
        ops.put(SpatialOps.TRANSFORM, SpatialTemplatesSupport.createSpatial(prefix + "Transform", 2, asFunction));
        ops.put(SpatialOps.UNION, SpatialTemplatesSupport.createSpatial(prefix + "Union", 2, asFunction));
        ops.put(SpatialOps.WITHIN, SpatialTemplatesSupport.createSpatial(prefix + "Within", 2, asFunction));
        ops.put(SpatialOps.WKBTOSQL, SpatialTemplatesSupport.createSpatial(prefix + "WKBToSQL", 2, asFunction));
        ops.put(SpatialOps.WKTTOSQL, SpatialTemplatesSupport.createSpatial(prefix + "WKTToSQL", 2, asFunction));
        ops.put(SpatialOps.X, SpatialTemplatesSupport.createSpatial(prefix + "X", 1, asFunction));
        ops.put(SpatialOps.X2, SpatialTemplatesSupport.createSpatial(prefix + "X", 2, asFunction));
        ops.put(SpatialOps.Y, SpatialTemplatesSupport.createSpatial(prefix + "Y", 1, asFunction));
        ops.put(SpatialOps.Y2, SpatialTemplatesSupport.createSpatial(prefix + "Y", 2, asFunction));
        ops.put(SpatialOps.Z, SpatialTemplatesSupport.createSpatial(prefix + "Z", 1, asFunction));
        ops.put(SpatialOps.Z2, SpatialTemplatesSupport.createSpatial(prefix + "Z", 2, asFunction));
        return ops;
    }
}

