/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.Maps;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.DefaultSQLExceptionTranslator;
import com.mysema.query.sql.JDBCTypeMapping;
import com.mysema.query.sql.JavaTypeMapping;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLExceptionTranslator;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLListeners;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SchemaAndTable;
import com.mysema.query.sql.types.Null;
import com.mysema.query.sql.types.Type;
import com.mysema.query.types.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class Configuration {
    public static final Configuration DEFAULT = new Configuration(SQLTemplates.DEFAULT);
    private final JDBCTypeMapping jdbcTypeMapping = new JDBCTypeMapping();
    private final JavaTypeMapping javaTypeMapping = new JavaTypeMapping();
    private final Map<SchemaAndTable, SchemaAndTable> schemaTables = Maps.newHashMap();
    private final Map<String, String> schemas = Maps.newHashMap();
    private final Map<String, String> tables = Maps.newHashMap();
    private final Map<SchemaAndTable, Map<String, String>> schemaTableColumns = Maps.newHashMap();
    private final Map<String, Map<String, String>> tableColumns = Maps.newHashMap();
    private final Map<String, Class<?>> typeToName = Maps.newHashMap();
    private final SQLTemplates templates;
    private SQLExceptionTranslator exceptionTranslator = DefaultSQLExceptionTranslator.DEFAULT;
    private final SQLListeners listeners = new SQLListeners();
    private boolean hasTableColumnTypes = false;
    private boolean useLiterals = false;

    public Configuration(SQLTemplates templates) {
        this.templates = templates;
        for (Type<?> type : templates.getCustomTypes()) {
            this.javaTypeMapping.register(type);
        }
        for (Map.Entry entry : templates.getTableOverrides().entrySet()) {
            this.schemaTables.put((SchemaAndTable)entry.getKey(), (SchemaAndTable)entry.getValue());
        }
    }

    public String asLiteral(Object o) {
        Type<?> type = this.javaTypeMapping.getType(o.getClass());
        if (type != null) {
            return this.templates.serialize(type.getLiteral(o), type.getSQLTypes()[0]);
        }
        throw new IllegalArgumentException("Unsupported literal type " + o.getClass().getName());
    }

    public SQLTemplates getTemplates() {
        return this.templates;
    }

    @Deprecated
    public Class<?> getJavaType(int sqlType, int size, int digits, String tableName, String columnName) {
        return this.getJavaType(sqlType, null, size, digits, tableName, columnName);
    }

    public Class<?> getJavaType(int sqlType, String typeName, int size, int digits, String tableName, String columnName) {
        Class<?> clazz;
        Type<?> type = this.javaTypeMapping.getType(tableName, columnName);
        if (type != null) {
            return type.getReturnedClass();
        }
        if (typeName != null && !this.typeToName.isEmpty() && (clazz = this.typeToName.get(typeName.toLowerCase())) != null) {
            return clazz;
        }
        return this.jdbcTypeMapping.get(sqlType, size, digits);
    }

    @Nullable
    public <T> T get(ResultSet rs, @Nullable Path<?> path, int i, Class<T> clazz) throws SQLException {
        return this.getType(path, clazz).getValue(rs, i);
    }

    @Deprecated
    public String getSchema(String schema) {
        return this.schemas.get(schema);
    }

    @Deprecated
    public String getTable(String schema, String table) {
        return this.getOverride(new SchemaAndTable(schema, table)).getTable();
    }

    @Nullable
    public SchemaAndTable getOverride(SchemaAndTable key) {
        if (!this.schemaTables.isEmpty() && key.getSchema() != null && this.schemaTables.containsKey(key)) {
            return this.schemaTables.get(key);
        }
        String schema = key.getSchema();
        String table = key.getTable();
        boolean changed = false;
        if (this.schemas.containsKey(key.getSchema())) {
            schema = this.schemas.get(key.getSchema());
            changed = true;
        }
        if (this.tables.containsKey(key.getTable())) {
            table = this.tables.get(key.getTable());
            changed = true;
        }
        return changed ? new SchemaAndTable(schema, table) : key;
    }

    public String getColumnOverride(SchemaAndTable key, String column) {
        String newColumn = null;
        Map<String, String> columnOverrides = this.schemaTableColumns.get(key);
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return newColumn;
        }
        columnOverrides = this.tableColumns.get(key.getTable());
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return newColumn;
        }
        return column;
    }

    public <T> void set(PreparedStatement stmt, Path<?> path, int i, T value) throws SQLException {
        if (Null.class.isInstance(value)) {
            Integer sqlType;
            Integer n = sqlType = path != null ? this.jdbcTypeMapping.get(path.getType()) : null;
            if (sqlType != null) {
                stmt.setNull(i, sqlType);
            } else {
                stmt.setNull(i, 0);
            }
        } else {
            this.getType(path, value.getClass()).setValue(stmt, i, value);
        }
    }

    private <T> Type<T> getType(@Nullable Path<?> path, Class<T> clazz) {
        String column;
        String table;
        Type<?> type;
        if (this.hasTableColumnTypes && path != null && !clazz.equals(Null.class) && path.getMetadata().getParent() instanceof RelationalPath && (type = this.javaTypeMapping.getType(table = ((RelationalPath)path.getMetadata().getParent()).getTableName(), column = ColumnMetadata.getName(path))) != null) {
            return type;
        }
        return this.javaTypeMapping.getType(clazz);
    }

    public String registerSchemaOverride(String oldSchema, String newSchema) {
        return this.schemas.put(oldSchema, newSchema);
    }

    public String registerTableOverride(String oldTable, String newTable) {
        return this.tables.put(oldTable, newTable);
    }

    public String registerTableOverride(String schema, String oldTable, String newTable) {
        SchemaAndTable st = this.registerTableOverride(schema, oldTable, schema, newTable);
        return st != null ? st.getTable() : null;
    }

    public SchemaAndTable registerTableOverride(String schema, String oldTable, String newSchema, String newTable) {
        return this.registerTableOverride(new SchemaAndTable(schema, oldTable), new SchemaAndTable(newSchema, newTable));
    }

    public SchemaAndTable registerTableOverride(SchemaAndTable from, SchemaAndTable to) {
        return this.schemaTables.put(from, to);
    }

    public String registerColumnOverride(String schema, String table, String oldColumn, String newColumn) {
        SchemaAndTable key = new SchemaAndTable(schema, table);
        Map<String, String> columnOverrides = this.schemaTableColumns.get(key);
        if (columnOverrides == null) {
            columnOverrides = new HashMap<String, String>();
            this.schemaTableColumns.put(key, columnOverrides);
        }
        return columnOverrides.put(oldColumn, newColumn);
    }

    public String registerColumnOverride(String table, String oldColumn, String newColumn) {
        Map<String, String> columnOverrides = this.tableColumns.get(table);
        if (columnOverrides == null) {
            columnOverrides = new HashMap<String, String>();
            this.tableColumns.put(table, columnOverrides);
        }
        return columnOverrides.put(oldColumn, newColumn);
    }

    public void register(Type<?> type) {
        this.jdbcTypeMapping.register(type.getSQLTypes()[0], type.getReturnedClass());
        this.javaTypeMapping.register(type);
    }

    public void registerType(String typeName, Class<?> clazz) {
        this.typeToName.put(typeName.toLowerCase(), clazz);
    }

    public void registerNumeric(int total, int decimal, Class<?> javaType) {
        this.jdbcTypeMapping.registerNumeric(total, decimal, javaType);
    }

    public void registerNumeric(int beginTotal, int endTotal, int beginDecimal, int endDecimal, Class<?> javaType) {
        for (int total = beginTotal; total <= endTotal; ++total) {
            for (int decimal = beginDecimal; decimal <= endDecimal; ++decimal) {
                this.registerNumeric(total, decimal, javaType);
            }
        }
    }

    public void register(String table, String column, Class<?> javaType) {
        this.register(table, column, this.javaTypeMapping.getType(javaType));
    }

    public void register(String table, String column, Type<?> type) {
        this.javaTypeMapping.setType(table, column, type);
        this.hasTableColumnTypes = true;
    }

    public RuntimeException translate(SQLException ex) {
        return this.exceptionTranslator.translate(ex);
    }

    public RuntimeException translate(String sql, List<Object> bindings, SQLException ex) {
        return this.exceptionTranslator.translate(sql, bindings, ex);
    }

    public void addListener(SQLListener listener) {
        this.listeners.add(listener);
    }

    public SQLListeners getListeners() {
        return this.listeners;
    }

    public boolean getUseLiterals() {
        return this.useLiterals;
    }

    public void setUseLiterals(boolean useLiterals) {
        this.useLiterals = useLiterals;
    }

    public void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }
}

