/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLBindings;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.ValidatingVisitor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDeleteClause
extends AbstractSQLClause<SQLDeleteClause>
implements DeleteClause<SQLDeleteClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLDeleteClause.class);
    private static final ValidatingVisitor validatingVisitor = new ValidatingVisitor("Undeclared path '%s'. A delete operation can only reference a single table. Consider this alternative: DELETE ... WHERE EXISTS (subquery)");
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final List<QueryMetadata> batches = new ArrayList<QueryMetadata>();
    private DefaultQueryMetadata metadata = new DefaultQueryMetadata();
    private transient String queryString;
    private transient List<Object> constants;

    public SQLDeleteClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLDeleteClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
    }

    public SQLDeleteClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLDeleteClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLDeleteClause addBatch() {
        this.batches.add((QueryMetadata)this.metadata);
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
        return this;
    }

    private PreparedStatement createStatement() throws SQLException {
        this.listeners.preRender(this.context);
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        logger.debug(this.queryString);
        this.context.addSQL(this.queryString);
        this.listeners.rendered(this.context);
        this.listeners.prePrepare(this.context);
        PreparedStatement stmt = this.connection.prepareStatement(this.queryString);
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        return stmt;
    }

    private Collection<PreparedStatement> createStatements() throws SQLException {
        this.listeners.preRender(this.context);
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete(this.batches.get(0), this.entity);
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        logger.debug(this.queryString);
        this.context.addSQL(this.queryString);
        this.listeners.rendered(this.context);
        HashMap stmts = Maps.newHashMap();
        this.listeners.prePrepare(this.context);
        PreparedStatement stmt = this.connection.prepareStatement(this.queryString);
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        stmt.addBatch();
        stmts.put(this.queryString, stmt);
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        for (int i = 1; i < this.batches.size(); ++i) {
            this.listeners.preRender(this.context);
            serializer = this.createSerializer();
            serializer.serializeDelete(this.batches.get(i), this.entity);
            this.context.addSQL(serializer.toString());
            this.listeners.rendered(this.context);
            stmt = (PreparedStatement)stmts.get(serializer.toString());
            if (stmt == null) {
                this.listeners.prePrepare(this.context);
                stmt = this.connection.prepareStatement(serializer.toString());
                stmts.put(serializer.toString(), stmt);
                this.context.addPreparedStatement(stmt);
                this.listeners.prepared(this.context);
            }
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
            stmt.addBatch();
        }
        return stmts.values();
    }

    public long execute() {
        this.context = this.startContext(this.connection, (QueryMetadata)this.metadata, this.entity);
        PreparedStatement stmt = null;
        Collection<PreparedStatement> stmts = null;
        try {
            if (this.batches.isEmpty()) {
                stmt = this.createStatement();
                this.listeners.notifyDelete(this.entity, (QueryMetadata)this.metadata);
                this.listeners.preExecute(this.context);
                int rc = stmt.executeUpdate();
                this.listeners.executed(this.context);
                long l = rc;
                return l;
            }
            stmts = this.createStatements();
            this.listeners.notifyDeletes(this.entity, this.batches);
            this.listeners.preExecute(this.context);
            long rc = this.executeBatch(stmts);
            this.listeners.executed(this.context);
            long l = rc;
            return l;
        }
        catch (SQLException e) {
            this.onException(this.context, e);
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
            if (stmts != null) {
                this.close(stmts);
            }
            this.endContext(this.context);
        }
    }

    @Override
    public List<SQLBindings> getSQL() {
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
            return ImmutableList.of((Object)this.createBindings((QueryMetadata)this.metadata, serializer));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (QueryMetadata metadata : this.batches) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeDelete(metadata, this.entity);
            builder.add((Object)this.createBindings(metadata, serializer));
        }
        return builder.build();
    }

    public SQLDeleteClause where(Predicate p) {
        this.metadata.addWhere(p);
        return this;
    }

    public SQLDeleteClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.metadata.addWhere(p);
        }
        return this;
    }

    public SQLDeleteClause limit(@Nonnegative long limit) {
        this.metadata.setModifiers(QueryModifiers.limit((long)limit));
        return this;
    }

    public String toString() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
        return serializer.toString();
    }
}

