/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableSet;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;
import java.util.Set;

public class PostgresTemplates
extends SQLTemplates {
    protected static final Set<String> POSTGRES_RESERVED_WORDS = ImmutableSet.of((Object)"ALL", (Object)"ANALYSE", (Object)"ANALYZE", (Object)"AND", (Object)"ANY", (Object)"ARRAY", (Object[])new String[]{"AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLLATION", "COLUMN", "CONCURRENTLY", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FETCH", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LATERAL", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NOT", "NOTNULL", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VARIADIC", "VERBOSE", "WHEN", "WHERE", "WINDOW", "WITH"});

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new PostgresTemplates(escape, quote);
            }
        };
    }

    public PostgresTemplates() {
        this('\\', false);
    }

    public PostgresTemplates(boolean quote) {
        this('\\', quote);
    }

    public PostgresTemplates(char escape, boolean quote) {
        super(POSTGRES_RESERVED_WORDS, "\"", escape, quote);
        this.setDummyTable(null);
        this.setCountDistinctMultipleColumns(true);
        this.setCountViaAnalytics(true);
        this.setDefaultValues("\ndefault values");
        this.setSupportsUnquotedReservedWordsAsIdentifier(true);
        this.add(Ops.MATCHES, "{0} ~ {1}");
        this.add(Ops.INDEX_OF, "strpos({0},{1})-1");
        this.add(Ops.INDEX_OF_2ARGS, "strpos({0},{1})-1");
        this.add(Ops.StringOps.LOCATE, "strpos({1},{0})");
        this.add(Ops.StringOps.LOCATE2, "strpos(repeat('^',{2s}-1) || substr({1},{2s}),{0})");
        if (escape == '\\') {
            this.add(Ops.LIKE, "{0} like {1}");
            this.add(Ops.ENDS_WITH, "{0} like {%1}");
            this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1}");
            this.add(Ops.STARTS_WITH, "{0} like {1%}");
            this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%}");
            this.add(Ops.STRING_CONTAINS, "{0} like {%1%}");
            this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%}");
        }
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.LOG, "log({1},{0})");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "extract(dow from {0}) + 1");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "extract(doy from {0})");
        this.add(Ops.DateTimeOps.YEAR_WEEK, "(extract(isoyear from {0}) * 100 + extract(week from {0}))");
        this.add(Ops.AggOps.BOOLEAN_ANY, "bool_or({0})", 0);
        this.add(Ops.AggOps.BOOLEAN_ALL, "bool_and({0})", 0);
        this.add(Ops.DateTimeOps.ADD_YEARS, "{0} + interval '{1s} years'");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "{0} + interval '{1s} months'");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "{0} + interval '{1s} weeks'");
        this.add(Ops.DateTimeOps.ADD_DAYS, "{0} + interval '{1s} days'");
        this.add(Ops.DateTimeOps.ADD_HOURS, "{0} + interval '{1s} hours'");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "{0} + interval '{1s} minutes'");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "{0} + interval '{1s} seconds'");
        String yearsDiff = "date_part('year', age({1}, {0}))";
        String monthsDiff = "(" + yearsDiff + " * 12 + date_part('month', age({1}, {0})))";
        String weeksDiff = "trunc((cast({1} as date) - cast({0} as date))/7)";
        String daysDiff = "(cast({1} as date) - cast({0} as date))";
        String hoursDiff = "(" + daysDiff + " * 24 + date_part('hour', age({1}, {0})))";
        String minutesDiff = "(" + hoursDiff + " * 60 + date_part('minute', age({1}, {0})))";
        String secondsDiff = "(" + minutesDiff + " * 60 + date_part('second', age({1}, {0})))";
        this.add(Ops.DateTimeOps.DIFF_YEARS, yearsDiff);
        this.add(Ops.DateTimeOps.DIFF_MONTHS, monthsDiff);
        this.add(Ops.DateTimeOps.DIFF_WEEKS, weeksDiff);
        this.add(Ops.DateTimeOps.DIFF_DAYS, daysDiff);
        this.add(Ops.DateTimeOps.DIFF_HOURS, hoursDiff);
        this.add(Ops.DateTimeOps.DIFF_MINUTES, minutesDiff);
        this.add(Ops.DateTimeOps.DIFF_SECONDS, secondsDiff);
        this.addTypeNameToCode("bool", -7, true);
        this.addTypeNameToCode("bytea", -2);
        this.addTypeNameToCode("name", 12);
        this.addTypeNameToCode("int8", -5, true);
        this.addTypeNameToCode("bigserial", -5);
        this.addTypeNameToCode("int2", 5, true);
        this.addTypeNameToCode("int2", -6, true);
        this.addTypeNameToCode("int4", 4, true);
        this.addTypeNameToCode("serial", 4);
        this.addTypeNameToCode("text", 12);
        this.addTypeNameToCode("oid", -5);
        this.addTypeNameToCode("xml", 2009, true);
        this.addTypeNameToCode("float4", 7, true);
        this.addTypeNameToCode("float8", 8, true);
        this.addTypeNameToCode("bpchar", 1);
        this.addTypeNameToCode("timestamptz", 93);
    }
}

