/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.Pair;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLExpressions;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLServerTemplates;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.WindowFunction;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import java.util.List;

public class SQLServer2005Templates
extends SQLServerTemplates {
    private String topTemplate = "top ({0}) ";
    private String outerQueryStart = "select * from (\n  ";
    private String outerQueryEnd = ") a where ";
    private String limitOffsetTemplate = "rn > {0} and rn <= {1}";
    private String offsetTemplate = "rn > {0}";
    private String outerQuerySuffix = " order by rn";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new SQLServer2005Templates(escape, quote);
            }
        };
    }

    public SQLServer2005Templates() {
        this('\\', false);
    }

    public SQLServer2005Templates(boolean quote) {
        this('\\', quote);
    }

    public SQLServer2005Templates(char escape, boolean quote) {
        super(escape, quote);
        this.add(Ops.MathOps.LOG, "(LOG({0}) / LOG({1}))");
    }

    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            QueryModifiers mod = metadata.getModifiers();
            if (mod.getOffset() == null) {
                metadata = metadata.clone();
                metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Integer.class, (String)this.topTemplate, (Object[])new Object[]{mod.getLimit()})));
                context.serializeForQuery(metadata, forCountRow);
            } else {
                context.append(this.outerQueryStart);
                metadata = metadata.clone();
                WindowFunction<Long> rn = SQLExpressions.rowNumber().over();
                for (OrderSpecifier os : metadata.getOrderBy()) {
                    rn.orderBy((OrderSpecifier<?>)os);
                }
                metadata.addProjection(rn.as("rn"));
                metadata.clearOrderBy();
                context.serializeForQuery(metadata, forCountRow);
                context.append(this.outerQueryEnd);
                if (mod.getLimit() == null) {
                    context.handle(this.offsetTemplate, mod.getOffset());
                } else {
                    context.handle(this.limitOffsetTemplate, mod.getOffset(), mod.getLimit() + mod.getOffset());
                }
                context.append(this.outerQuerySuffix);
            }
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }

    @Override
    public void serializeDelete(QueryMetadata metadata, RelationalPath<?> entity, SQLSerializer context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.isRestricting()) {
            metadata = metadata.clone();
            metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Integer.class, (String)this.topTemplate, (Object[])new Object[]{mod.getLimit()})));
        }
        context.serializeForDelete(metadata, entity);
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }

    @Override
    public void serializeUpdate(QueryMetadata metadata, RelationalPath<?> entity, List<Pair<Path<?>, Expression<?>>> updates, SQLSerializer context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.isRestricting()) {
            metadata = metadata.clone();
            metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Integer.class, (String)this.topTemplate, (Object[])new Object[]{mod.getLimit()})));
        }
        context.serializeForUpdate(metadata, entity, updates);
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }
}

