/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.types;

import com.mysema.query.sql.types.AbstractType;
import com.mysema.util.MathUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractNumberType<T extends Number>
extends AbstractType<T> {
    public AbstractNumberType(int type) {
        super(type);
    }

    @Override
    public T getValue(ResultSet rs, int startIndex) throws SQLException {
        Object obj = rs.getObject(startIndex);
        if (obj instanceof Number) {
            return (T)MathUtils.cast((Number)((Number)obj), this.getReturnedClass());
        }
        if (obj instanceof Boolean) {
            return (T)MathUtils.cast((Number)(Boolean.TRUE.equals(obj) ? 1 : 0), this.getReturnedClass());
        }
        if (obj != null) {
            throw new IllegalArgumentException(obj.toString());
        }
        return null;
    }
}

