/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.types;

import com.mysema.query.sql.types.AbstractType;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigIntegerAsLongType
extends AbstractType<BigInteger> {
    public static final BigIntegerAsLongType DEFAULT = new BigIntegerAsLongType();

    public BigIntegerAsLongType() {
        super(2);
    }

    public BigIntegerAsLongType(int type) {
        super(type);
    }

    @Override
    public BigInteger getValue(ResultSet rs, int startIndex) throws SQLException {
        Number num = (Number)rs.getObject(startIndex);
        return num != null ? BigInteger.valueOf(num.longValue()) : null;
    }

    @Override
    public Class<BigInteger> getReturnedClass() {
        return BigInteger.class;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, BigInteger value) throws SQLException {
        st.setLong(startIndex, value.longValue());
    }
}

