/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.jdbc.Driver;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.FileUtil;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;

public class AcceptanceTest
extends QuietTestCase {
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private MysqldResourceI mysqld;
    private File baseDir;
    FileUtil fileUtil;
    Shell.Factory shellFactory;
    static /* synthetic */ Class class$com$mysql$jdbc$Driver;

    protected void setUp() {
        super.setUp();
        this.fileUtil = new FileUtil();
        this.shellFactory = new Shell.Factory();
    }

    protected void tearDown() {
        super.tearDown();
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.conn = null;
        }
        if (this.mysqld != null) {
            try {
                this.mysqld.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.baseDir != null) {
            new FileUtil().deleteTree(this.baseDir);
        }
    }

    public void testMain() throws Exception {
        TestUtil testUtil = new TestUtil();
        int port1 = testUtil.testPort();
        String url1 = "jdbc:mysql://127.0.0.1:" + port1 + "/test";
        String[] startArgs1 = new String[]{"--port=" + port1};
        String[] stopArgs1 = new String[]{"--shutdown"};
        int port2 = port1 + 1000;
        String url2 = "jdbc:mysql://127.0.0.1:" + port2 + "/test";
        File baseDir2 = new File(new FileUtil().tmp(), "cmxj-dir2");
        String[] startArgs2 = new String[]{"--port=" + port2, "--basedir=" + baseDir2};
        String[] stopArgs2 = new String[]{"--basedir=" + baseDir2, "--shutdown"};
        MysqldResource.main(startArgs1);
        MysqldResource.main(startArgs2);
        testUtil.assertConnectViaJDBC(url1);
        testUtil.assertConnectViaJDBC(url2);
        MysqldResource.main(stopArgs1);
        testUtil.assertConnectViaJDBC(url2);
        SQLException expected = null;
        try {
            testUtil.assertConnectViaJDBC(url1);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
        MysqldResource.main(stopArgs2);
        expected = null;
        try {
            testUtil.assertConnectViaJDBC(url2);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
    }

    public void testCreateUser() throws Exception {
        this.baseDir = new File(new FileUtil().tmp(), "mxj-user-test");
        this.fileUtil.deleteTree(this.baseDir);
        this.mysqld = new MysqldResource(this.baseDir);
        this.baseDir.mkdirs();
        HashMap<String, String> params = new HashMap<String, String>();
        int port = new TestUtil().testPort();
        params.put("port", Integer.toString(port));
        this.mysqld.start("mxj-user-test", params);
        String url = "jdbc:mysql://localhost:" + port + "/";
        String rootUser = "root";
        String rootPassword = "";
        this.makeDb(url + "test", rootUser, rootPassword);
        this.checkVersion(this.mysqld.getVersion());
        this.conn.close();
        this.conn = null;
        Driver driver = new Driver();
        Properties props = new Properties();
        props.setProperty("user", "JAVA");
        props.setProperty("password", "SAPR3");
        Exception exception = null;
        try {
            this.conn = driver.connect(url + "MY1", props);
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNull((String)("" + exception), (Object)exception);
        this.checkVersion(this.mysqld.getVersion());
    }

    private void checkVersion(String version) throws SQLException {
        this.stmt = this.conn.createStatement();
        this.rs = this.stmt.executeQuery("SELECT VERSION()");
        int cols = this.rs.getMetaData().getColumnCount();
        AcceptanceTest.assertTrue((boolean)this.rs.next());
        AcceptanceTest.assertTrue((cols >= 1 ? 1 : 0) != 0);
        String searchIn = this.rs.getString(1);
        AcceptanceTest.assertTrue((String)("<" + version + "> not found in <" + searchIn + ">"), (boolean)new Str().containsIgnoreCase(searchIn, version));
        AcceptanceTest.assertEquals((int)cols, (int)1);
        AcceptanceTest.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
    }

    private void makeDb(String url, String userName, String password) throws Exception {
        new TestUtil().assertConnectViaJDBC(url, userName, password, true);
        Class.forName((class$com$mysql$jdbc$Driver == null ? (class$com$mysql$jdbc$Driver = AcceptanceTest.class$("com.mysql.jdbc.Driver")) : class$com$mysql$jdbc$Driver).getName());
        this.conn = DriverManager.getConnection(url, userName, password);
        this.stmt = this.conn.createStatement();
        this.stmt.execute("CREATE DATABASE MY1");
        this.stmt.execute("USE MY1");
        String sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'%' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        this.stmt.execute(sql);
        sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'localhost' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        this.stmt.execute(sql);
        this.stmt.execute("commit");
        this.stmt.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

