/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.MysqldResource;
import com.mysql.management.util.ClassUtil;
import com.mysql.management.util.Exceptions;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Threads;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

final class HelpOptionsParser {
    private static final String DIVIDER = "--------------------------------- -----------------------------";
    private static final String END_TEXT = "To see what values a running";
    private static final String NO_DEFAULT_VALUE = "(No default value)";
    private Threads threads;
    private PrintStream err;
    private ClassUtil classUtil;
    private Str str;

    HelpOptionsParser(PrintStream err, Threads threads, ClassUtil classUtil, Str str) {
        this.err = err;
        this.threads = threads;
        this.classUtil = classUtil;
        this.str = str;
    }

    public Map parseHelp(String help) {
        String trimmed = this.trimToOptions(help);
        final HashMap map = new HashMap();
        final BufferedReader reader = new BufferedReader(new StringReader(trimmed));
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() throws Exception {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf(32) <= 0) continue;
                    String key = line.substring(0, line.indexOf(32));
                    String val = line.substring(key.length()).trim();
                    if (val.equals(HelpOptionsParser.NO_DEFAULT_VALUE)) {
                        val = "";
                    }
                    map.put(key, val);
                }
            }
        };
        block.exec();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String trimToOptions(String help) {
        String string;
        block3: {
            StringBuffer msg2;
            boolean success = false;
            try {
                int dividerPos = help.indexOf(DIVIDER);
                int start = dividerPos + DIVIDER.length();
                int stop = help.indexOf(END_TEXT);
                if (dividerPos == -1) {
                    throw new RuntimeException("Can not parse: <" + help + ">");
                }
                help = help.substring(start, stop);
                help = help + System.getProperty("line.separator");
                success = true;
                string = help;
                Object var8_7 = null;
                if (success) break block3;
                msg2 = new StringBuffer();
                msg2.append("[");
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (success) break block4;
                    StringBuffer msg2 = new StringBuffer();
                    msg2.append("[");
                    msg2.append(this.classUtil.shortName(this));
                    msg2.append("] parsing unseccessful:");
                    msg2.append(this.str.newLine());
                    msg2.append(help);
                    this.err.println(msg2);
                }
                throw throwable;
            }
            msg2.append(this.classUtil.shortName(this));
            msg2.append("] parsing unseccessful:");
            msg2.append(this.str.newLine());
            msg2.append(help);
            this.err.println(msg2);
        }
        return string;
    }

    private Map getOptionsFromHelp(MysqldResource mysqldResource, Map params) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream capturedOut = new PrintStream(bos);
        params.put("help", null);
        params.put("verbose", null);
        final Shell s = mysqldResource.exec("getOptions", params, capturedOut, capturedOut, false);
        new Exceptions.VoidBlock(){

            protected void inner() throws InterruptedException {
                s.join();
            }
        }.exec();
        this.threads.pause(100);
        capturedOut.flush();
        capturedOut.close();
        Map options = this.parseHelp(new String(bos.toByteArray()));
        options.remove("help");
        params.remove("help");
        options.remove("verbose");
        params.remove("verbose");
        return options;
    }

    public Map getCurrentOptions(final MysqldResource mysqldResource, final Map params) {
        return (Map)new Exceptions.Block(){

            public Object inner() throws Exception {
                return HelpOptionsParser.this.getOptionsFromHelp(mysqldResource, params);
            }
        }.exec();
    }
}

