/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.util.ClassUtil;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.Threads;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import junit.framework.TestCase;

public class HelpOptionsParserTest
extends TestCase {
    public void testOptionParser() throws Exception {
        String resourceVersionDir = "4.1.13".replaceAll("\\.", "-");
        HelpOptionsParserTest.assertEquals((String)"4-1-13", (String)resourceVersionDir);
        String sampleHelp = resourceVersionDir + "/com/mysql/management/MySQL_Help.txt";
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(sampleHelp);
        String help = new Streams().readString(is);
        is.close();
        HelpOptionsParser parser = new HelpOptionsParser(System.err, new Threads(), new ClassUtil(), new Str());
        Map parsed = parser.parseHelp(help);
        HelpOptionsParserTest.assertEquals((Object)"/usr/local/mysql/", parsed.get("basedir"));
        HelpOptionsParserTest.assertEquals((Object)"TRUE", parsed.get("bdb"));
        HelpOptionsParserTest.assertEquals((Object)"", parsed.get("time-format"));
    }

    public void testTrimOptionsErrorMsg() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HelpOptionsParser parser = new HelpOptionsParser(new PrintStream(out), new Threads(), new ClassUtil(), new Str());
        Exception expected = null;
        try {
            parser.trimToOptions("bogus");
        }
        catch (Exception e) {
            expected = e;
        }
        HelpOptionsParserTest.assertNotNull((Object)expected);
        String errMsg = new String(out.toByteArray());
        HelpOptionsParserTest.assertTrue((errMsg.indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }
}

