/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.ClassUtil;
import com.mysql.management.util.CommandLineOptionsParser;
import com.mysql.management.util.Exceptions;
import com.mysql.management.util.FileUtil;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TeeOutputStream;
import com.mysql.management.util.Threads;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MysqldResource
implements MysqldResourceI {
    private String versionString;
    private Map options;
    private Shell shell;
    private File baseDir;
    private File pidFile;
    private String msgPrefix;
    private String pid;
    private String osName;
    private String osArch;
    private PrintStream out;
    private PrintStream err;
    private Exception trace;
    private int killDelay;
    private List completionListensers;
    private boolean readyForConnections;
    private HelpOptionsParser optionParser;
    private FileUtil fileUtil;
    private Streams streams;
    private Shell.Factory shellFactory;
    private ClassUtil classUtil;
    private Threads threads;
    private Str str;
    static /* synthetic */ Class class$com$mysql$management$MysqldResource;

    public MysqldResource() {
        this(new FileUtil().nullFile());
    }

    public MysqldResource(File baseDir) {
        this(baseDir, System.out, System.err);
    }

    public MysqldResource(File baseDir, PrintStream out, PrintStream err) {
        this(baseDir, out, err, new FileUtil(), new Shell.Factory(), new Streams(), new Threads(), new Str(), new ClassUtil());
    }

    MysqldResource(File baseDir, PrintStream out, PrintStream err, FileUtil fileUtil, Shell.Factory shellFactory, Streams streams, Threads threads, Str str, ClassUtil classUtil) {
        this.out = out;
        this.err = err;
        this.fileUtil = fileUtil;
        this.shellFactory = shellFactory;
        this.streams = streams;
        this.threads = threads;
        this.str = str;
        this.classUtil = classUtil;
        this.optionParser = new HelpOptionsParser(err, threads, classUtil, str);
        this.versionString = "4.1.13";
        this.killDelay = 30000;
        this.baseDir = baseDir.equals(fileUtil.nullFile()) ? new File(fileUtil.tmp(), "mysql-c.mxj") : baseDir;
        this.pidFile = null;
        this.msgPrefix = "[" + classUtil.shortName(this.getClass()) + "] ";
        this.options = new HashMap();
        this.setShell(null);
        this.setOsAndArch(System.getProperty("os.name"), System.getProperty("os.arch"));
        this.trace = new Exception();
        this.completionListensers = new ArrayList();
    }

    public void start(String threadName, Map mysqldArgs) {
        boolean ready;
        String lookFor;
        String lookIn2;
        if (this.getShell() != null || this.processRunning()) {
            this.printMessage("mysqld already running (process: " + this.pid() + ")");
            return;
        }
        this.options = this.optionParser.getCurrentOptions(this, mysqldArgs);
        this.out.flush();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream baes = new ByteArrayOutputStream();
        TeeOutputStream teeOutStream = new TeeOutputStream(this.out, baos);
        TeeOutputStream teeErrStream = new TeeOutputStream(this.err, baes);
        this.addCompletionListenser(new Runnable(){

            public void run() {
                MysqldResource.this.setReadyForConnection(false);
                MysqldResource.this.setShell(null);
                MysqldResource.this.completionListensers.remove(this);
            }
        });
        PrintStream psOut = new PrintStream(teeOutStream);
        PrintStream psErr = new PrintStream(teeErrStream);
        this.setShell(this.exec(threadName, mysqldArgs, psOut, psErr, true));
        long launchtime = System.currentTimeMillis();
        this.reportPid();
        long giveUp = launchtime + (long)this.killDelay;
        for (ready = false; !ready && System.currentTimeMillis() < giveUp; ready |= this.str.containsIgnoreCase(lookIn2, lookFor)) {
            lookFor = "ready for connections";
            String lookIn1 = baos.toString();
            lookIn2 = baes.toString();
            ready = this.str.containsIgnoreCase(lookIn1, lookFor);
            this.threads.pause(100);
        }
        teeOutStream.nullStreamTwo();
        teeErrStream.nullStreamTwo();
        this.setReadyForConnection(ready);
    }

    private void setReadyForConnection(boolean ready) {
        this.readyForConnections = ready;
    }

    public synchronized boolean isReadyForConnections() {
        return this.readyForConnections;
    }

    private void reportPid() {
        boolean printed = false;
        long giveUp = System.currentTimeMillis() + 3000L;
        while (!printed && System.currentTimeMillis() < giveUp) {
            if (this.pidFile().exists() && this.pidFile().length() > 0L) {
                this.threads.pause(25);
                this.printMessage("mysqld running as process: " + this.pid());
                this.out.flush();
                printed = true;
            }
            this.threads.pause(100);
        }
        this.reportIfNoPidfile(printed);
    }

    synchronized String pid() {
        if (this.pid == null) {
            if (!this.pidFile().exists()) {
                return "No PID";
            }
            Exceptions.Block block = new Exceptions.Block(){

                public Object inner() throws IOException {
                    return MysqldResource.this.fileUtil.asString(MysqldResource.this.pidFile()).trim();
                }
            };
            this.pid = (String)block.exec();
        }
        return this.pid;
    }

    void reportIfNoPidfile(boolean pidFileFound) {
        if (!pidFileFound) {
            this.printWarning("mysqld pid-file not found:  " + this.pidFile());
        }
    }

    public synchronized void shutdown() {
        boolean haveShell;
        boolean bl = haveShell = this.getShell() != null;
        if (!this.pidFile().exists() && !haveShell) {
            this.printMessage("Mysqld not running. No file: " + this.pidFile());
            return;
        }
        this.printMessage("stopping mysqld (process: " + this.pid() + ")");
        this.issueNormalKill();
        if (this.processRunning()) {
            this.issueForceKill();
        }
        if (this.shellRunning()) {
            this.destroyShell();
        }
        this.setShell(null);
        if (this.processRunning()) {
            this.printWarning("Process " + this.pid + "still running; not deleting " + this.pidFile());
        } else {
            this.threads.pause(150);
            System.gc();
            this.threads.pause(150);
            this.pidFile().deleteOnExit();
            this.pidFile().delete();
            this.pidFile = null;
            this.pid = null;
        }
        this.setReadyForConnection(false);
        this.printMessage("clearing options");
        this.options.clear();
        this.out.flush();
        this.printMessage("shutdown complete");
    }

    void destroyShell() {
        String shellName = this.getShell().getName();
        this.printWarning("attempting to destroy thread " + shellName);
        this.getShell().destroyProcess();
        this.waitForShellToDie();
        String msg = (this.shellRunning() ? "not " : "") + "destroyed.";
        this.printWarning(shellName + " " + msg);
    }

    void issueForceKill() {
        this.printWarning("attempting to \"force kill\" " + this.pid());
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() {
                new ProcessUtil(MysqldResource.this.pid(), MysqldResource.this.err, MysqldResource.this.err).forceKill();
            }
        };
        block.execSwallowingException(this.err);
        this.waitForProcessToDie();
        if (this.processRunning()) {
            String msg = (this.processRunning() ? "not " : "") + "killed.";
            this.printWarning(this.pid() + " " + msg);
        } else {
            this.printMessage("force kill " + this.pid() + " issued.");
        }
    }

    private void issueNormalKill() {
        if (!this.pidFile().exists()) {
            this.printWarning("Not running? File not found: " + this.pidFile());
            return;
        }
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() {
                new ProcessUtil(MysqldResource.this.pid(), MysqldResource.this.err, MysqldResource.this.err).kill();
            }
        };
        block.execSwallowingException(this.err);
        this.waitForProcessToDie();
    }

    private void waitForProcessToDie() {
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.processRunning() && System.currentTimeMillis() < giveUp) {
            this.threads.pause(250);
        }
    }

    private void waitForShellToDie() {
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.shellRunning() && System.currentTimeMillis() < giveUp) {
            this.threads.pause(250);
        }
    }

    public synchronized Map getServerOptions() {
        if (this.options.isEmpty()) {
            this.options = this.optionParser.getCurrentOptions(this, new HashMap());
        }
        return new HashMap(this.options);
    }

    public synchronized boolean isRunning() {
        return this.shellRunning() || this.processRunning();
    }

    private boolean processRunning() {
        return this.pidFile().exists() && new ProcessUtil(this.pid(), this.out, this.err).isRunning();
    }

    private boolean shellRunning() {
        return this.getShell() != null && this.getShell().isAlive();
    }

    public synchronized String getVersion() {
        return this.versionString;
    }

    private String getVersionDir() {
        return this.getVersion().replaceAll("\\.", "-");
    }

    public synchronized void setVersion(int MajorVersion, int minorVersion, int patchLevel) {
        this.versionString = MajorVersion + "." + minorVersion + "." + patchLevel;
    }

    private void printMessage(String msg) {
        this.println(this.out, msg);
    }

    private void printWarning(String msg) {
        this.println(this.err, "");
        this.println(this.err, msg);
    }

    private void println(PrintStream stream, String msg) {
        stream.println(this.msgPrefix + msg);
    }

    final void setOsAndArch(String osName, String osArch) {
        if (osName.indexOf("Win") != -1) {
            osName = "Win";
        }
        this.osName = osName;
        this.osArch = osArch;
    }

    synchronized Shell exec(String threadName, Map mysqldArgs, PrintStream outStream, PrintStream errStream, boolean withListeners) {
        mysqldArgs.put("basedir", this.baseDir.getPath());
        mysqldArgs.put("pid-file", this.pidFile().getPath());
        this.socket(mysqldArgs);
        File dataDir = this.dataDir(mysqldArgs);
        this.makeMysqld();
        this.ensureEssentialFilesExist(dataDir);
        Object[] args = this.constructArgs(mysqldArgs);
        outStream.println(this.str.toString(args));
        Shell launch = this.shellFactory.newShell((String[])args, threadName, outStream, errStream);
        if (withListeners) {
            for (int i = 0; i < this.completionListensers.size(); ++i) {
                Runnable listener = (Runnable)this.completionListensers.get(i);
                launch.addCompletionListener(listener);
            }
        }
        launch.setDaemon(true);
        this.printMessage("launching mysqld (" + threadName + ")");
        launch.start();
        return launch;
    }

    File makeMysqld() {
        File mysqld = this.getMysqldFilePointer();
        if (!mysqld.exists()) {
            mysqld.getParentFile().mkdirs();
            this.streams.createFileFromResource(this.getResourceName(), mysqld);
        }
        this.fileUtil.addExecutableRights(mysqld, this.out, this.err);
        return mysqld;
    }

    String getResourceName() {
        String dir = this.osName + "-" + this.osArch;
        String name = this.executableName();
        return this.getVersionDir() + "/" + dir + "/" + name;
    }

    private String executableName() {
        String mysqld = "mysqld";
        return this.isWindows() ? mysqld + "-nt.exe" : mysqld;
    }

    boolean isWindows() {
        return this.osName.equals("Win");
    }

    File getMysqldFilePointer() {
        File bin = new File(this.baseDir, "bin");
        return new File(bin, this.executableName());
    }

    void ensureEssentialFilesExist(File dataDir) {
        this.streams.expandResourceJar(dataDir, this.getVersionDir() + "/" + "data_dir.jar");
        this.streams.expandResourceJar(this.baseDir, this.getVersionDir() + "/" + this.shareJar());
    }

    void socket(Map mysqldArgs) {
        String socketString = (String)mysqldArgs.get("socket");
        if (socketString != null) {
            return;
        }
        File socket = new File(this.baseDir, "mysql.sock");
        mysqldArgs.put("socket", socket.toString());
    }

    File dataDir(Map mysqldArgs) {
        String dataDirString = (String)mysqldArgs.get("datadir");
        if (dataDirString != null) {
            return new File(dataDirString);
        }
        File dataDir = new File(this.baseDir, "data");
        mysqldArgs.put("datadir", dataDir.toString());
        return dataDir;
    }

    String[] constructArgs(Map mysqldArgs) {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.getMysqldFilePointer().getPath());
        strs.add("--no-defaults");
        if (this.isWindows()) {
            strs.add("--console");
        }
        Iterator it = mysqldArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringBuffer buf = new StringBuffer("--");
            buf.append(key);
            if (value != null) {
                buf.append("=");
                buf.append(value);
            }
            strs.add(buf.toString());
        }
        return this.str.toStringArray(strs);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.getShell() != null) {
            this.printWarning("resource released without closure.");
            this.trace.printStackTrace(this.err);
        }
    }

    String shareJar() {
        String shareJar = "share_dir.jar";
        if (this.isWindows()) {
            shareJar = "win_" + shareJar;
        }
        return shareJar;
    }

    void setShell(Shell shell) {
        this.shell = shell;
    }

    Shell getShell() {
        return this.shell;
    }

    File getBaseDir() {
        return this.baseDir;
    }

    public synchronized void setKillDelay(int millis) {
        this.killDelay = millis;
    }

    public synchronized void addCompletionListenser(Runnable listener) {
        this.completionListensers.add(listener);
    }

    void printUsage() {
        String command = "java " + (class$com$mysql$management$MysqldResource == null ? (class$com$mysql$management$MysqldResource = MysqldResource.class$("com.mysql.management.MysqldResource")) : class$com$mysql$management$MysqldResource).getName();
        String basedir = " --basedir";
        String datadir = " --datadir";
        this.out.println("Usage to start: ");
        this.out.println(command + " [ server options ]");
        this.out.println();
        this.out.println("Usage to shutdown: ");
        this.out.println(command + " --shutdown [" + basedir + "=/full/path/to/basedir ]");
        this.out.println();
        this.out.println("Common server options include:");
        this.out.println(basedir + "=/full/path/to/basedir");
        this.out.println(datadir + "=/full/path/to/datadir");
        this.out.println(" --socket=/full/path/to/socketfile");
        this.out.println();
        this.out.println("Example:");
        this.out.println(command + basedir + "=/home/duke/dukeapp/db" + datadir + "=/data/dukeapp/data" + " --max_allowed_packet=65000000");
        this.out.println(command + " --shutdown" + basedir + "=/home/duke/dukeapp/db");
        this.out.println();
    }

    private synchronized File pidFile() {
        if (this.pidFile == null) {
            String className = this.classUtil.shortName(this.getClass());
            this.pidFile = new File(this.baseDir, className + ".pid");
        }
        return this.pidFile;
    }

    public static void main(String[] args) {
        CommandLineOptionsParser clop = new CommandLineOptionsParser(args);
        MysqldResource mysqld = new MysqldResource(clop.getBaseDir());
        if (args.length == 0) {
            mysqld.printUsage();
        } else if (clop.isShutdown()) {
            mysqld.shutdown();
        } else {
            mysqld.start(new Threads().newName(), clop.asMap());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

