/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.MysqldResource;
import com.mysql.management.util.ClassUtil;
import com.mysql.management.util.FileUtil;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TeeOutputStream;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public class MysqldResourceTest
extends QuietTestCase {
    private MysqldResource mysqldResource;
    private TestFileUtil fileUtil;
    private Threads threads;
    private TestUtil testUtil;
    private Shell.Factory shellFactory;
    private Streams streams;
    private Str str;
    private ClassUtil classUtil;

    protected void setUp() {
        super.setUp();
        this.testUtil = new TestUtil();
        this.threads = new Threads();
        this.fileUtil = new TestFileUtil();
        this.shellFactory = new Shell.Factory();
        this.streams = new Streams();
        this.str = new Str();
        this.classUtil = new ClassUtil();
        this.mysqldResource = new MysqldResource(this.fileUtil.nullFile(), System.out, System.err, this.fileUtil, this.shellFactory, this.streams, this.threads, this.str, this.classUtil);
        this.mysqldResource.setKillDelay(10000);
        File baseDir = this.mysqldResource.getBaseDir();
        this.fileUtil.deleteTree(baseDir);
        if (baseDir.exists()) {
            this.warn("residual files");
        }
    }

    protected void tearDown() {
        this.threads.pause(50);
        File baseDir = this.mysqldResource.getBaseDir();
        try {
            if (this.mysqldResource.isRunning()) {
                this.mysqldResource.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileUtil.deleteTree(baseDir);
        super.tearDown();
    }

    private void setSystemPropertiesToWinNT() {
        this.mysqldResource.setOsAndArch("Windows NT", "x86");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isWindows());
    }

    private void setSytemPropertiesToLinux() {
        this.mysqldResource.setOsAndArch("Linux", "i386");
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isWindows());
    }

    public void testLaunch() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        String port = "" + this.testUtil.testPort();
        args.put("port", port);
        String url = "jdbc:mysql://localhost:" + port + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.mysqldResource.start(threadName, args);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        for (int i = 0; i < 100 && !this.mysqldResource.isReadyForConnections(); ++i) {
            this.threads.pause(25);
        }
        this.testUtil.assertConnectViaJDBC(url, true);
        this.mysqldResource.start(threadName, args);
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
    }

    public void testUseDatabase() throws Exception {
        String url = "jdbc:mysql://localhost:" + this.testUtil.testPort() + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.startMysql(threadName);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        for (int i = 0; i < 100 && !this.mysqldResource.isReadyForConnections(); ++i) {
            this.threads.pause(25);
        }
        this.testUtil.assertConnectViaJDBC(url);
        this.mysqldResource.start(threadName, new HashMap());
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
    }

    private void startMysql(String threadName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "" + this.testUtil.testPort());
        this.mysqldResource.start(threadName, map);
    }

    public void testGetFileName() {
        File mysqld = this.mysqldResource.getMysqldFilePointer();
        MysqldResourceTest.assertNotNull((Object)mysqld);
        String name = mysqld.getPath();
        MysqldResourceTest.assertTrue((String)name, (name.indexOf("mysqld") > 0 ? 1 : 0) != 0);
    }

    public void testWindowsFileName() {
        this.setSystemPropertiesToWinNT();
        String resourceName = this.mysqldResource.getResourceName();
        String fileName = this.mysqldResource.getMysqldFilePointer().getName();
        MysqldResourceTest.assertTrue((resourceName.indexOf("-nt.exe") > 0 ? 1 : 0) != 0);
        MysqldResourceTest.assertTrue((fileName.indexOf("-nt.exe") > 0 ? 1 : 0) != 0);
    }

    private void checkMysqldFile() {
        File mysqld = this.mysqldResource.makeMysqld();
        MysqldResourceTest.assertTrue((boolean)mysqld.exists());
        MysqldResourceTest.assertTrue((mysqld.length() > 100L ? 1 : 0) != 0);
    }

    public void testGetMysqldNative() {
        this.checkMysqldFile();
    }

    public void testGetMysqldWinNT() {
        this.setSystemPropertiesToWinNT();
        this.checkMysqldFile();
    }

    public void testGetMysqldLinux() {
        this.setSytemPropertiesToLinux();
        this.checkMysqldFile();
        MysqldResourceTest.assertTrue((boolean)this.fileUtil.madeExecutable(this.mysqldResource.getMysqldFilePointer()));
    }

    public void testUnknownOs() {
        this.mysqldResource.setOsAndArch("bogus", "x86");
        MissingResourceException expected = null;
        try {
            this.mysqldResource.makeMysqld();
        }
        catch (MissingResourceException e) {
            expected = e;
        }
        MysqldResourceTest.assertNotNull((String)("" + this.mysqldResource.getMysqldFilePointer()), (Object)expected);
        MysqldResourceTest.assertTrue((expected.getMessage().indexOf("bogus") > 0 ? 1 : 0) != 0);
    }

    public void testCreateDbFiles() {
        File dataDir = new File(this.mysqldResource.getBaseDir(), "test-data");
        File dbDataDir = new File(dataDir, "mysql");
        File host_frm = new File(dbDataDir, "host.frm");
        MysqldResourceTest.assertEquals((boolean)false, (boolean)host_frm.exists());
        MysqldResourceTest.assertEquals((boolean)false, (boolean)dataDir.exists());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("datadir", dataDir.getPath());
        File data = this.mysqldResource.dataDir(args);
        this.mysqldResource.ensureEssentialFilesExist(data);
        MysqldResourceTest.assertEquals((Object)dataDir, (Object)data);
        MysqldResourceTest.assertTrue((boolean)host_frm.exists());
    }

    private void assertRunningThenShutdown() {
        this.assertRunning();
        this.mysqldResource.shutdown();
        this.assertNotRunning();
    }

    private void assertNotRunning() {
        for (int i = 0; i < 500 && this.mysqldResource.isRunning(); ++i) {
            this.threads.pause(25);
        }
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
    }

    private void assertRunning() {
        for (int i = 0; i < 500 && !this.mysqldResource.isRunning(); ++i) {
            this.threads.pause(25);
        }
        MysqldResourceTest.assertTrue((String)"mysqld should be running", (boolean)this.mysqldResource.isRunning());
    }

    public void testServerOptions() {
        Map optionsMap = this.mysqldResource.getServerOptions();
        String expectedBaseDir = this.mysqldResource.getBaseDir().getPath();
        MysqldResourceTest.assertEquals((Object)expectedBaseDir, optionsMap.get("basedir"));
    }

    public void testTestReporting() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.fileUtil.nullFile(), captured, captured, this.fileUtil, this.shellFactory, this.streams, this.threads, this.str, this.classUtil);
        this.mysqldResource.reportIfNoPidfile(true);
        captured.flush();
        MysqldResourceTest.assertEquals((String)"", (String)new String(baos.toByteArray()));
        this.mysqldResource.reportIfNoPidfile(false);
        captured.flush();
        String output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "pid-file not found");
        this.testUtil.assertContainsIgnoreCase(output, this.fileUtil.tmp().toString());
    }

    public void testForceKill() {
        this.startMysql("killMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.issueForceKill();
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isRunning());
    }

    public void testDestroyShell() {
        this.startMysql("DestroyMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.destroyShell();
        if (this.mysqldResource.isRunning()) {
            new MysqldResource(this.fileUtil.nullFile()).shutdown();
        }
    }

    public void testVersion() {
        MysqldResourceTest.assertEquals((String)"4.1.13", (String)this.mysqldResource.getVersion());
        this.mysqldResource.setVersion(5, 11, 42);
        MysqldResourceTest.assertEquals((String)"5.11.42", (String)this.mysqldResource.getVersion());
    }

    public void testNoPidFile() {
        MysqldResourceTest.assertEquals((String)this.mysqldResource.pid(), (String)"No PID");
        this.startMysql("pid file");
        MysqldResourceTest.assertTrue((Integer.parseInt(this.mysqldResource.pid()) > 0 ? 1 : 0) != 0);
    }

    public void testTestFinalize() throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.fileUtil.nullFile(), captured, captured, this.fileUtil, this.shellFactory, this.streams, this.threads, this.str, this.classUtil);
        this.mysqldResource.finalize();
        captured.flush();
        String output = new String(baos.toByteArray());
        MysqldResourceTest.assertEquals((String)"", (String)output);
        NullPrintStream devNull = new NullPrintStream();
        String[] none = new String[]{};
        this.mysqldResource.setShell(new Shell.Default(none, "bogus", devNull, devNull));
        this.mysqldResource.finalize();
        captured.flush();
        output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        TeeOutputStream newOut = new TeeOutputStream(System.out, captured);
        PrintStream stdout = System.out;
        System.setOut(new PrintStream(newOut));
        try {
            MysqldResource.main(new String[0]);
        }
        finally {
            System.setOut(stdout);
        }
        MysqldResourceTest.assertTrue((baos.toString().indexOf("Usage") >= 0 ? 1 : 0) != 0);
    }

    public void testJarName() {
        this.setSystemPropertiesToWinNT();
        MysqldResourceTest.assertEquals((String)"win_share_dir.jar", (String)this.mysqldResource.shareJar());
        this.setSytemPropertiesToLinux();
        MysqldResourceTest.assertEquals((String)"share_dir.jar", (String)this.mysqldResource.shareJar());
    }

    private static class TestFileUtil
    extends FileUtil {
        private List execFiles = new ArrayList();

        private TestFileUtil() {
        }

        public void addExecutableRights(File mysqld, PrintStream out, PrintStream err) {
            this.execFiles.add(mysqld);
            super.addExecutableRights(mysqld, out, err);
        }

        public boolean madeExecutable(File file) {
            return this.execFiles.contains(file);
        }
    }
}

